      subroutine setbyclsd (p,pv,im,jm,nmvec)
c
c=======================================================================
c                                                                    ===
c  This routine sets the open segments of the transport stream-      ===
c  function by values imposed along the coastlines.                  ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     P       initial guess for transport function.   (real array)   ===
c     PV      interior vorticity & transport BCs      (real array)   ===
c     IM      number of points in the x-direction.    (integer)      ===
c     JM      number of points in the y-direction.    (integer)      ===
c     NMVEC   dimension for P and PV.                 (integer)      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CSTSEGX    coast x-coordinate.                 (integer array) ===
c     CSTSEGX    coast y-coordinate.                 (integer array) ===
c     CVALOPN    transport streamfn at each coast.   (real array)    ===
c     LENSEG     number of points per coast.         (integer vector)===
c     NOPNSEG    number of open basin segments.      (integer)       ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT     standard output unit.               (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     P       now with updated boundary values.       (real array)   ===
c     PV      now with updated boundary values.       (real array)   ===
c                                                                    ===
c  Call:  GET_OPN                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer   bndysz
      real      c0
      parameter (bndysz=4*mx, c0=0.0)
c
      integer im,ip,ipp,jm,m,n,nmvec,nnxt,nopn
      integer iopn(bndysz),jopn(bndysz)
      real    atot,pshft,veldiff
      real    abtrns(bndysz),p(nmvec),pv(nmvec)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Report action to echo file.
c-----------------------------------------------------------------------
c
      write (stdout,900)
c
c-----------------------------------------------------------------------
c  Update open segments based on requested boundary values.
c-----------------------------------------------------------------------
c
      do 30 n = 1, nopnseg
c
c  Get open segment indices.
c
         if (n.lt.nopnseg) then
            nnxt = n + 1
          else
            nnxt = 1
         end if
c
         call get_opn (cstsegx(lenseg(n),n),cstsegy(lenseg(n),n),
     &                 cstsegx(1,nnxt),cstsegy(1,nnxt),bndysz,im,jm,
     &                 nopn,iopn,jopn)
c
c  Get original shape function along open segment.
c
         atot      = c0
         abtrns(1) = c0
c
         do 10 m = 2, nopn
            ip  = iopn(m-1) + (jopn(m-1)-1)*im
            ipp = iopn(m  ) + (jopn(m  )-1)*im
            abtrns(m) = abs(p(ipp) - p(ip))
            atot      = atot + abtrns(m)
  10     continue
c
c  Construct correction factor.
c
         ip  = iopn(1) + (jopn(1)-1)*im
         ipp = iopn(nopn) + (jopn(nopn)-1)*im
c
         veldiff = ( (p(ipp)-p(ip)) + (cvalopn(1,n)-cvalopn(1,nnxt)) )
     &             / atot
c
         pshft = cvalopn(1,n) - p(ip)
c
c  Reset transport streamfunction along open segment.
c
         p(ip)   = cvalopn(1,n)
         pv(ip)  = cvalopn(1,n)
c
         p(ipp)  = cvalopn(1,nnxt)
         pv(ipp) = cvalopn(1,nnxt)
c
         atot=c0
         do 20 m = 2, (nopn-1)
            ip     = iopn(m) + (jopn(m)-1)*im
            atot   = atot + abtrns(m)
            p(ip)  = p(ip) + pshft - veldiff*atot
            pv(ip) = p(ip)
  20     continue
c
  30  continue
c
      return
c
 900  format (/'Resetting transport boundary conditions by values ',
     &        'specified at coasts.')
c
      end
