      subroutine setbyopn (p,pv,im,jm,nmvec)
c
c=======================================================================
c                                                                    ===
c  This routine sets the open segments of the transport stream-      ===
c  function by values imposed along the open segments.               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     P       initial guess for transport function.   (real array)   ===
c     PV      interior vorticity & transport BCs      (real array)   ===
c     IM      number of points in the x-direction.    (integer)      ===
c     JM      number of points in the y-direction.    (integer)      ===
c     NMVEC   dimension for P and PV.                 (integer)      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CSTSEGX    coast x-coordinate.                 (integer array) ===
c     CSTSEGX    coast y-coordinate.                 (integer array) ===
c     CVALOPN    transport streamfn bndy values.     (real array)    ===
c     LENSEG     number of points per coast.         (integer vector)===
c     NOPNSEG    number of open basin segments.      (integer)       ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT     standard output unit.               (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     P       now with updated boundary values.       (real array)   ===
c     PV      now with updated boundary values.       (real array)   ===
c                                                                    ===
c  Call:  GET_OPN                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer   bndysz
      parameter (bndysz=4*mx)
c
      integer im,ip,jm,m,n,nmvec,nnxt,nopn
      integer iopn(bndysz),jopn(bndysz)
      real    p(nmvec),pv(nmvec)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Report action to echo file.
c-----------------------------------------------------------------------
c
      write (stdout,900)
c
c-----------------------------------------------------------------------
c  Update open segments based on requested boundary values.
c-----------------------------------------------------------------------
c
      do 20 n = 1, nopnseg
c
c  Get open segment indices.
c
         if (n.lt.nopnseg) then
            nnxt = n + 1
          else
            nnxt = 1
         end if
c
         call get_opn (cstsegx(lenseg(n),n),cstsegy(lenseg(n),n),
     &                 cstsegx(1,nnxt),cstsegy(1,nnxt),bndysz,im,jm,
     &                 nopn,iopn,jopn)
c
c  Set transport streamfunction along open segment.
c
         do 10 m = 1, nopn
            ip     = iopn(m) + (jopn(m)-1)*im
            p(ip)  = cvalopn(m,n)
            pv(ip) = cvalopn(m,n)
  10     continue
c
  20  continue
c
      return
c
 900  format (/'Resetting transport boundary conditions to ',
     &        'specified values.')
c
      end
