      subroutine setclsd (p,pv,im,jm,nmvec)
c
c=======================================================================
c                                                                    ===
c  This routine sets the closed boundary segments of the transport   ===
c  streamfunction by the values at the ends of the open segments.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     P       initial guess for transport function.   (real array)   ===
c     PV      interior vorticity & transport BCs      (real array)   ===
c     IM      number of points in the x-direction.    (integer)      ===
c     JM      number of points in the y-direction.    (integer)      ===
c     NMVEC   dimension for P and PV.                 (integer)      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CSTSEGX   coast x-coordinate.                  (integer array) ===
c     CSTSEGY   coast y-coordinate.                  (integer array) ===
c     LANDP     transport streamfn land/sea mask.    (integer array) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     P       now with updated boundary values.       (real array)   ===
c     PV      now with updated boundary values.       (real array)   ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,ip,ipp,j,jm,llseg,nmvec
      real    p(nmvec),pv(nmvec)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set Northern & Southern closed boundary values.
c-----------------------------------------------------------------------
c
      do 10 i = 1, im
c
c     Southern
c
         ip   = i
         llseg = landp(ip)
         if (llseg.gt.0) then
            ipp    = cstsegx(1,llseg) + (cstsegy(1,llseg)-1)*im
            pv(ip) = pv(ipp)
            p(ip)  = p(ipp)
         end if
c
c     Northern
c
         ip   = i + (jm-1)*im
         llseg = landp(ip)
         if (llseg.gt.0) then
            ipp    = cstsegx(1,llseg) + (cstsegy(1,llseg)-1)*im
            pv(ip) = pv(ipp)
            p(ip)  = p(ipp)
         end if
c
  10  continue
c
c-----------------------------------------------------------------------
c  Set Eastern & Western closed boundary values.
c-----------------------------------------------------------------------
c
      do 20 j = 1, jm
c
c     Eastern
c
         ip   = j*im
         llseg = landp(ip)
         if (llseg.gt.0) then
            ipp    = cstsegx(1,llseg) + (cstsegy(1,llseg)-1)*im
            pv(ip) = pv(ipp)
            p(ip)  = p(ipp)
         end if
c
c     Western
c
         ip   = 1 + (j-1)*im
         llseg = landp(ip)
         if (llseg.gt.0) then
            ipp    = cstsegx(1,llseg) + (cstsegy(1,llseg)-1)*im
            pv(ip) = pv(ipp)
            p(ip)  = p(ipp)
         end if
c
  20  continue
c
      return
      end
