      subroutine setdepths
c
c=======================================================================
c                                                                    ===
c  This routine sets the depths at the tracers (T,S)  and velocity   ===
c  (u,v) points. These depths are used to interpolate these fields   ===
c  to hybrid (topography-following) coordinates.                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <iounits.h>
#include <ndimen.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real       cm2m,p25,p5
      parameter (cm2m=0.01, p5=0.5, p25=0.25)
c
      integer k
#ifdef gridold
     &        ,i,ip,j
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Compute interface depth (or flat levels thickness) HC and the
c  average thickness of the hybrid levels HAVG
c-----------------------------------------------------------------------
c
      if((kc.lt.0).or.(kc.gt.km)) then
        write(stdout,10) kc
  10    format(/,' SETDEPTHS - illegal interface level, KC = ',i4)
        call exitus('SETDEPTHS')
      endif
      hc=0.0
      do 20 k=1,kc
        hc=hc+hz(k)
  20  continue
      havg=0.0
      do 30 k=kc+1,km
        havg=havg+hz(k)
  30  continue
      write(stdout,40)
  40  format(/' PE Model: ZPE (m), HZ (m)',/)
      do 60 k=1,km
        write(stdout,50) k,zpe(k)*cm2m,hz(k)*cm2m
  50    format(i4,4f11.5 )
  60  continue
#ifdef gridold
      write(stdout,70) kc,hc*cm2m,havg*cm2m
  70  format(/,'      kc = ',i4,/,'      hc = ',f12.3,' m',
     *       /,'    havg = ',f12.3,' m')
      if(dblsigma.eq.1) then
        write(stdout,80) zc1*cm2m,zc2*cm2m,zref*cm2m,zslope
  80    format(/,' Double vertical transformation parameters:',/,
     *         /,'     zc1 = ',f12.3,' m',/,'     zc2 = ',f12.3,' m',
     *         /,'    zref = ',f12.3,' m',/,'  zslope = ',f12.3)
      endif
c
c-----------------------------------------------------------------------
c  Set bottom depths at the U-V points.
c-----------------------------------------------------------------------
c
      do 100 j=1,jm-1
        do 90 i=1,im-1
          ip=i+(j-1)*im
          hv(ip)=p25*(h(ip)+h(ip+1)+h(ip+im)+h(ip+im+1))
  90    continue
        ip=j*im
        hv(ip)=p5*(h(ip)+h(ip+im))
 100  continue
      do 110 i=1,im-1
        ip=i+(jm-1)*im
        hv(ip)=p5*(h(ip)+h(ip+1))
 110  continue
      ip=im*jm
      hv(ip)=h(ip)
# ifdef reset_h
c
      do 120 ip=1,im*jm
        hsave(ip)=h(ip)
 120  continue
      do 140 j=2,jm
         do 130 i=2,im
            ip=i+(j-1)*im
            h(ip)=p25*(hv(ip-1)+hv(ip)+hv(ip-1-im)+hv(ip-im))
 130     continue
 140  continue
c
#  ifdef cyclic
      do 150 j=1,jm
         h(1+(j-1)*im)=h(jm-2+(j-1)*im)
         h(im+(j-1)*im)=h(2+(j-1)*im)
 150  continue
      do 160 i=2,im
         h(i)=h(i+im)
 160  continue
#  else
      do 150 j=2,jm
         h(1+(j-1)*im)=h(2+(j-1)*im)
 150  continue
      do 160 i=2,im
         h(i)=h(i+im)
 160  continue
      h(1)=p5*(h(1+im)+h(2))
#  endif
# endif
#endif
c
c-----------------------------------------------------------------------
c  Set the depths of each tracer and velocity point.
c-----------------------------------------------------------------------
c
      call vertgrid
c
c-----------------------------------------------------------------------
c  Compare model levels to supplied data levels.
c-----------------------------------------------------------------------
c
      call check_depths
c
      return
      end
