      subroutine shapmean (fld,fldmean,lda,nx,ny,action)
c
c=======================================================================
c                                                                    ===
c  This routine removes/replaces a mean field from a field for       ===
c  improved shapiro filtering along terrain following levels.        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     FLD......."Synoptic" scale field.        (real array)          ===
c     FLDMEAN..."Mean" scale field.            (real array)          ===
c     LDA.......Leading dimension of arrays.   (integer)             ===
c     NX........Number of x-grid points.       (integer)             ===
c     NY........Number of y-grid points.       (integer)             ===
c     ACTION....Action to take on field.       (character)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FLD.......Modified field.                (real array)          ===
c                                                                    ===
c  Calls:  ALL_UC,  LENGTH                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,lda,nx,ny,sbgn,send,slen
      real         fld(lda,ny),fldmean(lda,ny)
      character*80  wkstr
      character*(*) action
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Put action in uniform form  (upper case).
c-----------------------------------------------------------------------
c
      call all_uc (action,wkstr)
      call length (wkstr,slen,sbgn,send)
c
c-----------------------------------------------------------------------
c  Perform requested action.
c-----------------------------------------------------------------------
c
      if (wkstr(sbgn:send).eq.'REMOVE') then
c
         do 10 j = 1, ny
         do 10 i = 1, nx
            fld(i,j) = fld(i,j) - fldmean(i,j)
  10     continue
c
        elseif (wkstr(sbgn:send).eq.'REPLACE') then
c
         do 20 j = 1, ny
         do 20 i = 1, nx
            fld(i,j) = fld(i,j) + fldmean(i,j)
  20     continue
c
      end if
c
      return
      end
