      subroutine swapdata
c
c=======================================================================
c                                                                    ===
c   This routine saves current fields so they can be used in the     ===
c   computation of the boundary conditions in PUT_BDRY.              ===
c                                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <ndimen.h>
#include <oldflds.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first
      integer i,ip,j,k,m
      save first
      data first /.true./
c
c=======================================================================
c  Begin excutable code.
c=======================================================================
c
      if(first) then
        dold=dcur
        first=.false.
      endif
      write(stdout,10) dold,dcur
  10  format(/' Swaping data between days: ',2f11.4)
c
c  Save current data.
c
      dold=dcur
      do 50 j=1,jm
        do 40 i=1,im
          ip=i+(j-1)*im
          ubarold(ip)=ubar(ip)
          vbarold(ip)=vbar(ip)
          pbarold(ip)=pbar(ip)
          do 30 k=1,km
            dwdzold(ip,k)=dwdz(ip,k)
            uold(ip,k)=u(ip,k)
            vold(ip,k)=v(ip,k)
            uiold(ip,k)=ui(ip,k)
            viold(ip,k)=vi(ip,k)
            do 20 m=1,nt
              told(ip,k,m)=t(ip,k,m)
  20        continue
  30      continue
  40    continue
  50  continue
      return
      end
