      subroutine transbdy (p,pv,im,jm,nmvec,rstil,pvsave)
c
c=======================================================================
c                                                                    ===
c  This routine sets values at the boundary of P and sets mask       ===
c  CSMASK  used in  CGPOIS1  to initialize values of P at land       ===
c  points.                                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     P       initial guess for transport function.   (real array)   ===
c     PV      interior vorticity & transport BCs      (real array)   ===
c     IM      number of points in the x-direction.    (integer)      ===
c     JM      number of points in the y-direction.    (integer)      ===
c     NMVEC   dimension for P and PV.                 (integer)      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CSTSEGX   coast x-coordinate.                  (integer array) ===
c     CSTSEGY   coast y-coordinate.                  (integer array) ===
c     CVALIS    values of transport at islands.      (real vector)   ===
c     CVALOPN   transport streamfn bndy values.      (real array)    ===
c     ICVALIS   Flag for setting Sfn around islands. (integer vector)===
c     NISLE     number of islands.                   (integer)       ===
c     NSEG      number of coastal segments.          (integer)       ===
c     LANDP     transport streamfn land/sea mask.    (integer array) ===
c     OPENSEG   Flag for setting Sfn around outside. (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     P       now with updated boundary values.       (real array)   ===
c     PV      now with updated boundary values.       (real array)   ===
c     PVSAVE  copy of PV for resetting islands later. (real array)   ===
c     RSTIL   Flag for resetting islands later.       (logical)      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CVAL    values of Sfn at coastal segments.     (real vector)   ===
c     CSMASK  Working land mask for transport        (integer array) ===
c             streamfunction, allows islands to be                   ===
c             handled iteratively                                    ===
c             CSMASK=0      at sea points.                           ===
c             CSMASK=LSEG   at land points bounded by coastal        ===
c                           segment LSEG.                            ===
c                                                                    ===
c  Calls:   SETBYCLSD,  SETBYOPN,  SETCLSD,  TRANSOBDY               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer im,ip,isl,jm,llseg,nmvec
      logical rstil
      real    p(nmvec),pv(nmvec),pvsave(nmvec)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Reset open segments, if requested.
c-----------------------------------------------------------------------
c
      if (openseg.eq.1)  then
         call setbyclsd (p,pv,im,jm,nmvec)
         call setclsd (p,pv,im,jm,nmvec)
       elseif ((openseg.eq.2).and.(nisle.lt.nseg))  then
         call setbyopn (p,pv,im,jm,nmvec)
         call setclsd (p,pv,im,jm,nmvec)
       elseif ((openseg.eq.2).and.(nisle.eq.nseg))  then
         call transobdy (p,pv,im,jm,nmvec)
      end if
c
c-----------------------------------------------------------------------
c  Set boundary values for each segment.
c-----------------------------------------------------------------------
c
      rstil = .false.
c
      do 10 llseg = 1, nseg
c
         isl = llseg - nseg + nisle
c
         if (isl.lt.1) then
            ip         = cstsegx(1,llseg) + im*(cstsegy(1,llseg)-1)
            cval(llseg) = pv(ip)
          elseif (icvalis(isl).ne.0) then
            cval(llseg) = cvalis(isl)
          else
            rstil = .true.
         end if
c
  10  continue
c
c-----------------------------------------------------------------------
c  Set working coastal mask, save copy of forcing array.
c-----------------------------------------------------------------------
c
      do 20 ip = 1, im*jm
c
         llseg = landp(ip)
         isl = llseg - nseg + nisle
c
         if (isl.lt.1) then
            csmask(ip) = llseg
          elseif (icvalis(isl).ne.0) then
            csmask(ip) = llseg
          else
            csmask(ip) = 0
         end if
c
         pvsave(ip) = pv(ip)
c
  20  continue
c
      return
      end
