      subroutine transobdy (p,pv,im,jm,nmvec)
c
c=======================================================================
c                                                                    ===
c  This routine sets values at the boundary of P  (assuming an open  ===
c  domain).                                                          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     P       array with initial guess for P.                        ===
c     PV      array with interior values set to vorticity and grid   ===
c             edges set to internally chosen boundary values.        ===
c     IM      number of points in the x-direction.                   ===
c     JM      number of points in the y-direction.                   ===
c     NMVEC   dimension for P and PV.                                ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CVALOPN    transport streamfn bndy values.     (real array)    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT     standard output unit.               (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     PV      array with boundary points overwritten with boundary   ===
c             values otherwise identical to PV at input.             ===
c                                                                    ===
c  Calls:   none                                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,ip,j,jm,n,nmvec
      real p(nmvec),pv(nmvec)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Report to echo file.
c-----------------------------------------------------------------------
c
      write (stdout,900)
c
c-----------------------------------------------------------------------
c  Assign boundary values along southern edge.
c-----------------------------------------------------------------------
c
      n = 0
      do 10 i=1,im
         ip = i
         n  = n + 1
         p (ip) = cvalopn(n,1)
         pv(ip) = cvalopn(n,1)
  10  continue
c
c-----------------------------------------------------------------------
c  Assign boundary values along eastern edge.
c-----------------------------------------------------------------------
c
      do 20 j=2,jm
         ip = j*im
         n  = n + 1
         p (ip) = cvalopn(n,1)
         pv(ip) = cvalopn(n,1)
  20  continue
c
c-----------------------------------------------------------------------
c  Assign boundary values along northern edge.
c-----------------------------------------------------------------------
c
      do 30 i=im-1,1,-1
         ip = i + (jm-1)*im
         n  = n + 1
         p (ip) = cvalopn(n,1)
         pv(ip) = cvalopn(n,1)
  30  continue
c
c-----------------------------------------------------------------------
c  Assign boundary values along western edge.
c-----------------------------------------------------------------------
c
      do 40 j=jm-1,2,-1
         ip = 1 + (j-1)*im
         n  = n + 1
         p (ip) = cvalopn(n,1)
         pv(ip) = cvalopn(n,1)
  40  continue
c
      return
c
 900  format (/' Resetting transport streamfunction BCs to supplied ',
     &        'values.')
c
      end
