      subroutine trc_names (ibiom)
c
c=======================================================================
c                                                                    ===
c  This routine resets the NetCDF names of the tracer variables as   ===
c  needed.  The default names are maintained in the block data code. ===
c                                                                    ===
c  Input:                                                            ===
c                                                                    ===
c     IBIOM   Flag to indicate the type of biological model.(integer)===
c             [0] No biological model.                               ===
c             [1] McGillicuddy et al. (1995)                         ===
c             [2] Anderson (1995) expansion of McGillicuddy model.   ===
c             [3] Fasham et al. (1990)                               ===
c                                                                    ===
c   Note:  Dusenberry biological model is handled using              ===
c          -DbioDuse compiler option, not IBIOM                      ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /PI_NETCDF/                                                       ===
c                                                                    ===
c     TNAME   The NetCDF names of the tracer variables.              ===
c             (charcter array)                                       ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <pi_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ibiom
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Reset NetCDF names of tracer variables as needed.
c
#ifndef bioDuse
cjad - obviously the call to this routine should be removed ifdef bioDuse
cjad - do later
      if(ibiom.eq.2) then
        tname(1,7)='detritus                                    '
        tname(2,7)='detritus concentraction                     '
        tname(3,7)='millimoles nitrogen meter-3                 '
        tname(4,7)='detritus, scalar                            '
      endif
#endif
c
      return
      end
