      subroutine ts2psi
c
c=======================================================================
c                                                                    ===
c  Computes psi from t,s                                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <meants.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
       integer i,ip,j,k
       real c0,grav,m2cm,p5,spval
       real dum,sig0,sig1,scle
       real azm(mprof),sigavg(nz),val(2),wk(nz,2)
c
       parameter(c0=0.0, grav=980.6, m2cm=100.0, p5=0.5, spval=1.0e30)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make depth vectors consistent
c-----------------------------------------------------------------------
c
      do 10 k=1,nprof
         azm(k) = abs(zm(k))*m2cm
 10   continue
c
c-----------------------------------------------------------------------
c  Compute averaged sigma
c-----------------------------------------------------------------------
c
      if (intopt.eq.1) then
         call spline (azm,tm,nprof,spval,spval,wk(1,1))
         call spline (azm,sm,nprof,spval,spval,wk(1,2))
      end if
c
      do 20 k=1,kfld
         if (intopt.eq.1) then
            call splint (azm,tm,wk(1,1),nprof,zfld(k),val(1),dum)
            call splint (azm,sm,wk(1,2),nprof,zfld(k),val(2),dum)
           else
            call lintrp (nprof,azm,tm,1,zfld(k),val(1))
            call lintrp (nprof,azm,sm,1,zfld(k),val(2))
         end if
         call state_ini(val(1),val(2),zfld(k),sigavg(k))
 20   continue
c
c-----------------------------------------------------------------------
c  Compute streamfunction related to internal pressure
c-----------------------------------------------------------------------
c
      scle = p5*grav/(f0*v0*dhor)
      do 50 j=1,jm
         do 40 i=1,im
            ip=i+(j-1)*im
            psi(ip,1)=c0
            call state_ini(t(ip,1,1),t(ip,1,2),zfld(1),sig0)
            sig0=sig0-sigavg(1)
            do 30 k=2,kfld
               call state_ini(t(ip,k,1),t(ip,k,2),zfld(k),sig1)
               sig1=sig1-sigavg(k)                
               psi(ip,k)=psi(ip,k-1)+
     &                   scle*(sig0+sig1)*(zfld(k)-zfld(k-1))
               sig0=sig1
 30         continue
 40      continue
 50   continue
c
      return
      end
