      function vel_err (im,jm,psi,resid,resscl)
c
c-----------------------------------------------------------------------
c     This function computes the relative change in the barotropic     |
c     velocity.  (The relative change becomes the absolute change for  |
c     velocities less than 1 cm/s).                                    |
c                                                                      |
c     Input:                                                           |
c                                                                      |
c     IM         number of points in the x-direction (integer).        |
c     JM         number of points in the y-direction (integer).        |
c     PSI        transport streamfunction (real array).                |
c     RESID      residual transport streamfunction (real array).       |
c     RESSCL     scaling facrot for RESID (real).                      |
c                                                                      |
c     Output:                                                          |
c                                                                      |
c     VEL_ERR    the relative change in the barotropic velocity. (real)|
c                                                                      |
c     Common Blocks:                                                   |
c                                                                      |
c     /CSTSEG/                                                         |
c                                                                      |
c        ISMASK     mask at the velocity points.                       |
c                                                                      |
c     /GRDDAT/                                                         |
c                                                                      |
c        VMETX     x-coordinate metric coefficients at velocity grid   |
c                  (real array; cm).                                   |
c        VMETY     y-coordinate metric coefficients at velocity grid   |
c                  (real array; cm).                                   |
c                                                                      |
c     /HYBRID/                                                         |
c                                                                      |
c        HV         bathymetry (cm) at the velocity points (real array)|
c                                                                      |
c     /MODDAT/                                                         |
c                                                                      |
c        DX       mean grid spacing in the x-direction (cm or degrees).|
c        DY       mean grid spacing in the y-direction (cm or degrees).|
c                                                                      |
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     Define global data.                                              |
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <grddat.h>
#include <hybrid.h>
#include <moddat.h>
c
c-----------------------------------------------------------------------
c     Define local data.                                               |
c-----------------------------------------------------------------------
c
      integer i,im,ip,ip1,j,jm,jp1
      real    c0,c1,p5,psi(im,jm),resid(im,jm),resscl,u,ures,v,vel_err,
     &        vres
c
      parameter (c0=0.0, c1=1.0, p5=0.5)
c
c=======================================================================
c     Begin executable code.                                           #
c=======================================================================
c
c-----------------------------------------------------------------------
c     Initialize relative error.                                       |
c-----------------------------------------------------------------------
c
      vel_err = c0
c
c-----------------------------------------------------------------------
c     Loop over active interior points, testing convergence.           |
c-----------------------------------------------------------------------
c
      do 10 j = 1, jm-1
         do 10 i = 1, im-1
c
            ip = i + (j-1)*im
c
            if (ismask(ip).eq.0) then
c
               ip1 = i + 1
               jp1 = j + 1
c
               u = p5/(dy*vmety(ip)*hv(ip))*( (psi(i,j)-psi(i,jp1)) +
     &                                       (psi(ip1,j)-psi(ip1,jp1)) )
               ures = resscl*p5/(dy*vmety(ip)*hv(ip))*
     &                                 ( (resid(i,j)-resid(i,jp1)) +
     &                                   (resid(ip1,j)-resid(ip1,jp1)) )
               v = p5/(dx*vmetx(ip)*hv(ip))*( (psi(ip1,j)-psi(i,j)) +
     &                                       (psi(ip1,jp1)-psi(i,jp1)) )
               vres = resscl*p5/(dx*vmetx(ip)*hv(ip))*
     &                                 ( (resid(ip1,j)-resid(i,j)) +
     &                                   (resid(ip1,jp1)-resid(i,jp1)) )
c
               vel_err = max( vel_err, abs(ures)/max(abs(u),c1),
     &                                        abs(vres)/max(abs(v),c1) )
c
            end if
 10   continue
c
      return
      end
