      subroutine wrt_transbdy (trnsfile,nopn,nisle,lenopn,mxopn,popn,
     &                         corrcst,psisl)
c
c=======================================================================
c                                                                    ===
c  This routine writes the transport streamfunction boundary         ===
c  conditions                                                        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     TRNSFILE   Name of output  file.               (string)        ===
c     NOPN       Number of open boundary segments.   (integer)       ===
c     NISLE      Number of islands.                  (integer)       ===
c     LENOPN     Length of open boundary segments.   (integer vector)===
c     MXOPN      Maximum length of open segments.    (integer)       ===
c     POPN       Transport Sfn at open segs.         (real array)    ===
c     CORRCST    Identifier for coasts in coarse     (integer vector)===
c                grid which correspond to fine isles.                ===
c     PSISL      Sfunction values on the islands.    (real vector)   ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /IOUNITS/                                                        ===
c                                                                    ===
c     STDOUT     standard output unit.               (integer)       ===
c     ISLINP     output unit for transport around                    ===
c                islands and open segments.          (integer)       ===
c                                                                    ===
c  Calls:  EXITUS,  LENGTH,  NO_DIGIT                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ios,m,mxopn,n,nisle,nopn,sbgn,send,slen
      integer corrcst(nisle),lenopn(nopn)
      integer no_digit
      real          popn(mxopn,nopn),psisl(nisle)
      character*40  fmt
      character*(*) trnsfile
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open transport streamfunction boundary condition file.
c-----------------------------------------------------------------------
c
c  Determine length of transport Sfn BC file name.
c
      call length (trnsfile,slen,sbgn,send)
c
      if (slen.lt.1) then
         write (stdout,900)
         call exitus ('WRT_TRANSBDY')
      end if
c
c  Open transport Sfn BC file.
c
      open (islinp, file=trnsfile(sbgn:send), status='unknown',
     &      iostat=ios)
c
      if (ios.ne.0) then
         write (stdout,910) 'open',trnsfile(sbgn:send)
         call exitus ('GET_DOM')
      end if
c
c-----------------------------------------------------------------------
c  Write transport streamfunction boundary condition data.
c-----------------------------------------------------------------------
c
c  Write active flag.
c
      write (islinp,920) 2,'OPENSEG'
c
c  Write island data.
c
      write (islinp,920) nisle,'NISLAND'
c
      write (fmt,930) no_digit(nisle),no_digit(nisle)
c
      do 10 n = 1, nisle
         if (corrcst(n).gt.0) then
            write (islinp,fmt) '1',psisl(n),'ICVALIS(',n,'), CVALIS(',n,
     &                         ')'
          else
            write (islinp,fmt) '0',0.0,'ICVALIS(',n,'), CVALIS(',n,')'
         end if
  10  continue
c
c  Write outer boundary data.
c
      write (islinp,920) nopn,'NOPNSEG'
c
      write (fmt,940) no_digit(nopn),no_digit(nopn),no_digit(nopn)
c
      do 20 n = 1, nopn
         write (islinp,fmt) lenopn(n),'NPTSOPN(',n,
     &                      '), and line(s) below CVALOPN(1:nptsopn(',n,
     &                      '),',n,')'
         write (islinp,950) (popn(m,n), m=1, lenopn(n))
  20  continue
c
c-----------------------------------------------------------------------
c  Write file documentation.
c-----------------------------------------------------------------------
c
      write (islinp,1000)
      write (islinp,1010)
      write (islinp,1020)
      write (islinp,1030)
      write (islinp,1040)
      write (islinp,1050)
      write (islinp,1060)
      write (islinp,1070)
c
c-----------------------------------------------------------------------
c  Close transport streamfunction boundary condition file.
c-----------------------------------------------------------------------
c
      close (islinp)
c
      return
c
 900  format (/'***Error:  WRT_TRANSBDY - zero length name for',
     &        ' transport Sfn BC file.')
 910  format (/'***Error:  WRT_TRANSBDY - unable to ',a,
     &        ' transport Sfn BC file:'/11x,1h",a,1h")
 920  format (i5,t20,a)
 930  format ('(a,1x,1pe15.8,2x,a,i',i2,',a,i',i2,',a)')
 940  format ('(i10,t20,a,i',i2,',a,i',i2,',a,i',i2,',a)')
 950  format ((1pg14.7,4(1x,1pg14.7)))
1000  format (///'  Note:  This file provides the values for the',
     &        ' transport streamfunction'/'  ----   around each island'
     & ,' in the model basin and the transport'/9x,'streamfunction ',
     & 'along the open basin segments.  This file is read'/9x,'if the ',
     & 'Land/Sea data are available in the GRIDS NetCDF (which'/9x,
     & 'indicates a coastal set-up).'//9x,
     &  'If you wish to omit setting the transport from outside, set'
     &        /9x,'OPENSEG=0 and NISLAND=0.')
1010  format (/6x,'OPENSEG     A switch for handling the transport '
     &        'streamfunction along'/18x,'the N-open basin segments:'
     &    /18x,'OPENSEG=0    Impose the values found internally at the'
     &    /31x,'open basin segment (open boundary).'
     &    /18x,'OPENSEG=1    Impose the given value along coastline n.'
     &    /31x,'(actually imposing closed segments)'
     &    /18x,'OPENSEG=2    Impose the values given in CVALOPN(n),'
     &       /31x,'which are prescribed in this file.')
1020  format (/6x,'NISLAND     '
     &       'The number of islands in the basin. This must be the same'
     &/18x,'number as that in the GRIDS NetCDF file (variable "nisle").'
     &/18x,'If NISLAND=0, do not prescribe ICVALIS and CVALIS'
     &/18x,'because they are not read.'//18x,'if (nisland.gt.0) then'
     &/21x,'do n=1,nisland'/24x,'read(*,*) icvalis(n),cvalis(n)'
     &        /21x,'enddo'/18x,'endif')
1030  format (/6x,'ICVALIS(n)  A switch '
     &        'that indicates how to set the transport around'
     &/18x,'the Nth island:'
     &/18x,'ICVALIS(n)=0   A 2-step process.  First the streamfunction'
     &/33x,'is computed ignoring this island.  Then'
     &/33x,'the average value around the island coast'
     &/33x,'is used to set the constant value.'
     &/18x,'ICVALIS(n)=1   Impose the value given in CVALIS(n)'
     &       /33x,'which is prescribed in this file.')
1040  format (/6x,'CVALIS(n)   The transport '
     &        'streamfunction (cm^3/s) value around the'
     &/18x,'Nth island.  Match the island sequence number (n) to'
     &/18x,'that provided in the GRIDS NetCDF file (variables "isis",'
     &/18x,'ieis", "jsis", "jeis"). That is, CVALIS(1) corresponds'
     &/18x,'to island 1 in the GRIDS NetCDF file.'
     &        //18x,'1 Sv = 1.0e+06 m^3/s = 1.0e+12 cm^3/s')
1050  format (/6x,'NOPNSEG     The number '
     &        'of open basin segments, excluding interior'
     &/18x,'islands; that is, islands that do not intercept the'
     &        /18x,'basin (model domain) boundary.')
1060  format (/6x,'NPTSOPN     The number '
     &        'of points in each open basin segment.'
     &        /18x,'If OPENSEG=1, NPTSOPN should also be 1.')
1070  format (/6x,'CVALOPN     The transport '
     &        'streamfunction at each point for the Nth-open'
     &/18x,'basin segment, CVALOPN(NPTSOPN,NOPNSEG).  Enter the'
     &/18x,'values is such a way that water is always to the left'
     &/18x,'when looking from the position of the first point'
     &/18x,'toward the second point of the open segment.  If more'
     &/18x,'and one open segment (NOPNSEG>1), enter then in the'
     &/18x,'same logical order as in the GRIDS NetCDF file.'
     &//18x,'FORTRAN statements:'//18x,
     &'if (openseg.eq.1.or.openseg.eq.2) then'
     &/21x,'read(*,*) nopnseg'/21x,'do n=1,nopnseg'
     &/24x,'read(*,*) nptsopn(n)'
     &/24x,'read(*,*) (cvalopn(i,n),i=1,nptsopn(n))'
     &/21x,'enddo'/18x,'endif')
c
      end
