      subroutine xtr_psiby (cpbar,nopn,lenopn,popn)
c
c=======================================================================
c                                                                    ===
c  This routine extracts the transport streamfunction boundary       ===
c  conditions.                                                       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CPBAR     Coarse transport Sfn field.          (real vector)   ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /FNE_DOM/                                                        ===
c                                                                    ===
c     FICST    Fine coastline x-components.      (integer array)     ===
c     FJCST    Fine coastline y-components.      (integer array)     ===
c     FLNCST   Lengths of coastlines, fine.      (integer vector)    ===
c     FNCST    Number of coastlines in fine.     (integer)           ===
c     FNISL    Number of islands in fine grid.   (integer)           ===
c     FNX      Number of fine points in x-dir.   (integer)           ===
c     FNY      Number of fine points in y-dir.   (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NOPN      Number of open boundary segments.    (integer)       ===
c     LENOPN    Length of open boundary segments.    (integer vector)===
c     POPN      Transport Sfn at open segs.          (real array)    ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c  Calls:  GET_OPN,  INTRP_PBAR                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <fne_dom.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer n,nnxt,nopn
      integer lenopn(mcseg),iopn(mpseg),jopn(mpseg)
      real    cpbar(np),popn(mpseg,mcseg)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Determine number of open boundary segments boarding coasts in fine
c  grid.
c-----------------------------------------------------------------------
c
      nopn = fncst - fnisl
c
c-----------------------------------------------------------------------
c  Extract boundary values.
c-----------------------------------------------------------------------
c
      if (nopn.gt.0) then
c
c  Extract in the presence of coasts.
c
         do 10 n = 1, nopn
c
            if (n.lt.nopn) then
               nnxt = n + 1
             else
               nnxt = 1
            end if
c
            call get_opn (ficst(flncst(n),n),fjcst(flncst(n),n),
     &                    ficst(1,nnxt),fjcst(1,nnxt),
     &                    mpseg,fnx,fny,lenopn(n),iopn,jopn)
c
            call intrp_pbar (lenopn(n),iopn,jopn,cpbar,popn(1,n))
c
  10     continue
c
       else
c
c  Extract a totally open domain.
c
         nopn = 1
c
         call get_opn (1,1,1,2,mpseg,fnx,fny,lenopn(1),iopn,jopn)
c
         call intrp_pbar (lenopn(1),iopn,jopn,cpbar,popn)
c
      end if
c
      return
      end
