      subroutine xy2ll(x,y,coord,nx,ny,gridx,gridy,rlngd,rlatd,
     *                 delx,dely,thetad,lon,lat)
c
c=======================================================================
c                                                                    ===
c  This routine computes the longitude and latitude of a given       ===
c  point from the supplied grid coordinates.                         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  X, Y      the corresponding grid coordinates        (real)        ===
c  COORD     flag for coordinate type                  (integer)     ===
c               [0]  cartesian (tangent plane) grid.                 ===
c               [1]  unrotated spherical grid.                       ===
c               [2]  rotated spherical grid.                         ===
c  DELX,                                                             ===
c  DELY      Offset from transformation point to                     ===
c            grid center.                              (real; cm|deg)===
c  NX, NY    number of grid points in x & y directions (integer)     ===
c  GRIDX     grid spacing in x-direction               (real; cm|deg)===
c  GRIDY     grid spacing in y-direction               (real; cm|deg)===
c  RLNGD     longitude at center of grid               (real; deg)   ===
c  RLATD     latitude at center of grid                (real; deg)   ===
c  THETAD    angle grid is rotated with respect to east (real; deg)  ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  LON, LAT  the longitude and latitude of the point   (real; deg)   ===
c                                                                    ===
c  Calls:  ROTPARM                                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical new
      integer coord,coordo,nx,ny,nxo,nyo
      real a,c0,c1,c2pi,c180,cm1,c360,cm360,cos1,cosp,cosr,cterm,
     *     deg2rad,delx,delxo,dely,delyo,dx,dy,gdxo,gdyo,gridx,gridy,
     *     lat,lon,p5,pi,plat,plon,rad2deg,re,re_d2r,rf1x,rf1y,rf2x,
     *     rf2y,rlat,rlatd,rlato,rlon,rlngd,rlngo,rnlon,sin1,sinp,sinr,
     *     sterm,thetad,thetao,x,xc,y,yc
      real lon_chk
      parameter (c0=0.0,c1=1.0,c180=180.0, c360=360.0, cm1=-1.0, p5=0.5,
     *           pi=3.14159 26535 89793 23846, re=637131500.0)
      parameter (cm360=cm1*c360, c2pi=pi+pi, deg2rad=pi/c180, 
     *           rad2deg=c180/pi, re_d2r=re*deg2rad)
c
      save coordo,cosp,cterm,delxo,delyo,gdxo,gdyo,nxo,nyo,plat,plon,
     *     rf1x,rf1y,rf2x,rf2y,rlato,rlngo,rnlon,sinp,sterm,thetao,xc,yc
c
      data coordo,nxo,nyo /3*0/
      data delxo,delyo,gdxo,gdyo,rlato,rlngo,thetao /7*c0/
c
c=======================================================================
c  Longitude range check function.
c=======================================================================
c
      lon_chk(a)=sign(c1,a)*
     *           (mod(abs(a),c2pi)-c2pi*int(mod(abs(a),c2pi)/pi))
c
c-----------------------------------------------------------------------
c Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c Determine if working with a new coordinate system.
c-----------------------------------------------------------------------
c
      new = (nx.ne.nxo).or.(ny.ne.nyo).or.(thetad.ne.thetao).or.
     *      (rlatd.ne.rlato).or.(rlngd.ne.rlngo).or.(gridx.ne.gdxo).or.
     *      (gridy.ne.gdyo).or.(coord.ne.coordo).or.(delx.ne.delxo).or.
     *         (dely.ne.delyo)
      if (new) then
        coordo = coord
        delxo  = delx
        delyo  = dely
        gdxo   = gridx
        gdyo   = gridy
        nxo    = nx
        nyo    = ny
        rlato  = rlatd
        rlngo  = rlngd
        thetao = thetad
      endif
c
c-----------------------------------------------------------------------
c Cartesian (tangent plane) system.
c-----------------------------------------------------------------------
c
      if (coord.eq.0) then
        if (new) then
          rf1x  = gridx/re_d2r
          rf1y  = gridy/re_d2r
          rf2x  = rf1x/cos(rlatd*deg2rad)
          rf2y  = rf1y/cos(rlatd*deg2rad)
          sterm = sin(thetad*deg2rad)
          cterm = cos(thetad*deg2rad)
          xc    = p5*float(nx+1)-delx/gridx
          yc    = p5*float(ny+1)-dely/gridy
        endif
        dx  = x-xc
        dy  = y-yc
        lon = rlngd+rf2x*dx*cterm-rf2y*dy*sterm
        lat = rlatd+rf1y*dy*cterm+rf1x*dx*sterm
c
c-----------------------------------------------------------------------
c  Unrotated spherical system.
c-----------------------------------------------------------------------
c
      elseif (coord.eq.1) then
        if (new) then
          xc = p5*float(nx+1)-delx/gridx
          yc = p5*float(ny+1)-dely/gridy
        endif
        lon = (x-xc)*gridx
        lat = (y-yc)*gridy
c
c-----------------------------------------------------------------------
c  Rotated spherical system.
c-----------------------------------------------------------------------
c
      elseif (coord.eq.2) then
        if (new) then
          call rotparm (rlngd*deg2rad,rlatd*deg2rad,thetad*deg2rad,plat,
     *                  plon,rnlon)
          xc   = p5*float(nx+1)-delx/gridx
          yc   = p5*float(ny+1)-dely/gridy
          cosp = cos(plat)
          sinp = sin(plat)
        endif
        rlon = (x-xc)*gridx
        rlat = (y-yc)*gridy
        cosr = cos(rlat*deg2rad)
        sinr = sin(rlat*deg2rad)
        lat  = asin(sinr*sinp+cosr*cosp*cos(rlon*deg2rad-rnlon))
        sin1 = cosr*sin(rlon*deg2rad-rnlon)
        cos1 = sinr*cosp-sinp*cosr*cos(rlon*deg2rad-rnlon)
        lon  = plon-atan2(sin1,cos1)
        lon  = lon_chk(lon)
        lat  = lat*rad2deg
        lon  = lon*rad2deg
      endif
c
      return
      end
