c
c=======================================================================
c  Include file "zdat.h".
c=======================================================================
#ifndef rmdocinc
c
c  H        bathymetry (cm) at the tracer points (real array).
# ifdef gridold
#  ifdef reset_h
c  HSAVE    storage of original H
#  endif
# else
c  TINTER    the depth of interface at tracer grid points        
c            for double sigma coordinates (input; real array)    
c  VINTER    the depth of interface at velocity grid points      
c            for double sigma coordinates (input; real array)    
# endif
c  HZFLD    nominal vertical thicknesses (cm) in the input data (real
c           array).
c  KFLD     number of levels in input data (integer).
c  ZBOT     depth (cm) used to set flat topography (real).
c  ZFLD     depths (cm) of the flat levels in the input data (real
c           array).
c
c=======================================================================
#endif
c
      integer kfld
      common /izdat/ kfld
c
#ifdef gridold
# ifdef reset_h
      real zbot
      real h(np),hzfld(nz),zfld(nz),hsave(np)
      common /fzdat/ zbot,zfld,hzfld,h,hsave
# else
      real zbot
      real h(np),hzfld(nz),zfld(nz)
      common /fzdat/ zbot,zfld,hzfld,h
# endif
#else
      real zbot
      real h(np),hzfld(nz),zfld(nz),tinter(np),vinter(np)
      common /fzdat/ zbot,zfld,hzfld,h,tinter,vinter
#endif
