      subroutine baro_velocity
c
c=======================================================================
c                                                                    ===
c  This routine computes  the surface pressure                       ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <curflds.h>
#include <grddat.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
#include <hybrid.h>
#include <zdat.h>
#include <cstseg.h>
#include <convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,k,kzmin,kzmax,ip1
c
#ifdef coast
      integer isz(isesize),iez(isesize),isp(isesize),iep(isesize),
     *        isq(isesize),ieq(isesize)
      real    fkmz(np),fkmp(np),fkmq(np)
#endif
c
      real pv1(np,0:nz),pv2(np,0:nz),corpbar(np)
      real weigh(np),ztd(np),a(np*9),pwork(np),hvex(np)
      real fcori(np),utop(np),vtop(np)

      real sumpv1,sumpv2,zvalav1,zvalav2,zlayth,deltaz,deltaz1,deltaz2,
     *    psiH1,psiH2
      real pbaroS(ijmx),pbaroN(ijmx),pbaroW(ijmx),pbaroE(ijmx)
#ifndef solvercg
      integer ir(np),ia(np+1),ja(9*np)
      real
     *        am(9*np),rp(np),pspar(np)
#else
      double precision
     *        wk(np,4)
#endif
#if defined testinversion | defined localfilter
      real 
     *     xtest(np)
#endif
      real c0,c1,fac,grav,p5,cenlon,dxx,dyy
      real scle,yoff,cenlat,deg2cm,fx,deg2rad,pi,rearth
      parameter (c0=0.0,c1=1.0,grav=981.0,p5=0.5,rearth=6371.315e5,
     *           pi=3.14159 26535 89793 23846,deg2rad=pi/180.0,
     *           deg2cm=deg2rad*rearth)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      if (isesize.lt.jm*lseg) then
         write (stdout,*) 'Set ISESIZE in param.h to at least ',jm*lseg
         call exitus ('BARO_VELOCITY')
      endif
c
      write(stdout,10) dcur
 10   format(/,' Computing external velocity at day = ',
     *     f12.4)
c
c     Pass depth at u points to hvex
c     ------------------------------
c
      do 20 i=1,im
         do 20 j=1,jm
            ip=i+(j-1)*im
            hvex(ip)=hv(ip)
 20      continue
#ifdef coast
c
c     Get the masking indices
c     -----------------------
c
      call mskind(im,jm,km,lseg,landt,isz,iez,isq,ieq,isp,iep,hvex,
     *            fkmz,fkmp,fkmq)
#endif
c
c  If using horizontally uniform T,S; set internal mode velocities to zero
c  and surface pressure constant (zero external mode velocities).
c
      if(job.eq.3) then
        do 30 j=1,jm
        do 30 i=1,im
           ip=i+(j-1)*im
           ubar(ip)=c0
           vbar(ip)=c0
           pbar(ip)=c0
 30     continue
      else
c
c-----------------------------------------------------------------------
c     Set working array
c-----------------------------------------------------------------------
c
c
c     Compute barotropic velocity:
c     ---------------------------
         do 50 j=1,jm
         do 50 i=1,im
            ip=i+(j-1)*im
            pwork(ip)=c0
            weigh(ip)=c1/hv(ip)
            do 40 k=0,kfld 
               pv1(ip,k)=c0
               pv2(ip,k)=c0
 40         continue
 50      continue
         call grad_ts(im,jm,np,dx,dy,pbar,vmetx,vmety,weigh,vbar,ubar)
c
         do 60 j=1,jm
         do 60 i=1,im
            ip=i+(j-1)*im
            ubar(ip)=-ubar(ip)
 60      continue           
c
c  Prepare parameters to compute Coriolis parameter f
c
         scle=f0
         call xy2ll (p5*float(im+1),p5*float(jm+1),
     *        coord,im,jm,dx,dy,rlng0,
     *        rlat0,delx,dely,thetad,cenlon,cenlat)
c
         if (iflag(6).eq.3) fx=sin(cenlat*deg2rad)
         do 80 j=1,jm
            do 70 i=1,im
               ip=i+(j-1)*im
               if (iflag(6).eq.2) then
                  yoff=(geolat(ip)-cenlat)*deg2cm
                  scle=f0+beta*yoff
               elseif (iflag(6).eq.3) then
                  scle=f0*sin(geolat(ip)*deg2rad)/fx
               endif
               fcori(ip)=scle
 70         continue
 80      continue
         if (psurf.eq.2) then
c
c  Preparing first guess: (1) f/h  pbar 
c
            do 81 ip=1,im*jm
               corpbar(ip)=fcori(ip)*pbar(ip)/h(ip)
 81         continue
c
c Preparing first guess: (2) poteng/h
c
            call ts2poteng
c
c Set initial surface pressure guess
c
            do 90 ip=1,im*jm
               pbar(ip)=corpbar(ip)-poteng(ip)
 90         continue
         else
            fac=v0*dhor*f0
            do 100 ip=1,im*jm
               pbar(ip)=fac*psi(ip,1)
 100        continue
            if(psurf.eq.1) then
               do 101 ip=1,im*jm
                  utop(ip)=ubar(ip)+ui(ip,1)
                  vtop(ip)=vbar(ip)+vi(ip,1)
 101           continue
               call psurfbdy (utop,vtop,fcori)
            endif
         endif
c
c-----------------------------------------------------------------------
c  Preparing RHS: (1) Set internal pressure contribution:
c                     - Integral from -HV to z=0 of GRAD PI.
c
c                     PI= Pressure/rho (kinematic pressure)
c-----------------------------------------------------------------------
c
c  Compute (scaled) internal pressure (PSI) at z-levels
c  Note: original values of streamfunction PSI will be overwritten.
c
         call ts2psi
c
c  Form GRAD PI at all z-levels
c
         fac=v0*dhor*f0
         do 110 ip=1,im*jm
            weigh(ip)=fac
 110     continue
         do 120 k=1,kfld
            call grad_ts(im,jm,np,dx,dy,psi(1,k),vmetx,vmety,
     *           weigh,pv1(1,k),pv2(1,k))
 120     continue
c
c  Integrate Grad PI from surface to depth of (velocity-point) topography 
c
         do 170 j=1,jm
            do 160 i=1,im
c
               sumpv1=c0
               sumpv2=c0
               ip=i+(j-1)*im
c
               kzmin=1
               do 130 k=1,kfld
                  if(-zfld(k).gt.c0) then
                     kzmin=kzmin+1
                  endif
 130           continue
c
               kzmax=kfld
               do 140 k=kfld,1,-1
                  if(abs(zfld(k)).ge.abs(hv(ip))) then
                     kzmax=kzmax-1
                  endif
 140           continue
c
c            Interior points:
c
               do 150 k=kzmin,kzmax-1
                  zlayth=abs(zfld(k+1)-zfld(k))
                  zvalav1=p5*(pv1(ip,k  )+pv1(ip,k+1))
                  sumpv1=sumpv1+zvalav1*zlayth
                  zvalav2=p5*(pv2(ip,k  )+ pv2(ip,k+1))
                  sumpv2=sumpv2+zvalav2*zlayth
 150           continue
c
c     If top grid pt. above H=0 and/or bottom pt. below
c     H=H_max:
c
               if(abs(zfld(kzmin)).gt.c0) then
                  deltaz=abs(zfld(kzmin))
                  sumpv1=sumpv1+deltaz*pv1(ip,kzmin)
                  sumpv2=sumpv2+deltaz*pv2(ip,kzmin)
               endif
c
               if(abs(zfld(kzmax)).lt.abs(hv(ip))) then
                  if(kzmax.lt.kfld)then
                     deltaz1=abs(hv(ip))-abs(zfld(kzmax))
                     deltaz2=abs(zfld(kzmax+1))-abs(hv(ip))

                     psiH1=pv1(ip,kzmax+1)*deltaz1+
     *                    pv1(ip,kzmax  )*deltaz2
                     psiH1=psiH1/(deltaz1+deltaz2)
                     zvalav1=p5*(psiH1+pv1(ip,kzmax))
                     sumpv1=sumpv1+zvalav1*deltaz1

                     psiH2=pv2(ip,kzmax+1)*deltaz1+
     *                    pv2(ip,kzmax  )*deltaz2
                     psiH2=psiH2/(deltaz1+deltaz2)
                     zvalav2=p5*(psiH2+pv2(ip,kzmax))
                     sumpv2=sumpv2+zvalav2*deltaz1
                  else
                     deltaz1=abs(hv(ip))-abs(zfld(kzmax))
                     sumpv1=sumpv1+pv1(ip,kzmax)*deltaz1
                     sumpv2=sumpv2+pv2(ip,kzmax)*deltaz1
                  endif
               endif
               pv1(ip,0)=-sumpv1
               pv2(ip,0)=-sumpv2
 160        continue
 170     continue
c
c-----------------------------------------------------------------------
c  Preparing RHS: (2) Set Coriolis terms contribution:
c                     -f[-V,U]
c-----------------------------------------------------------------------
c
         do 180 ip=1,im*jm
            pv1(ip,0)= fcori(ip)*vbar(ip)*hv(ip)+pv1(ip,0)
            pv2(ip,0)=-fcori(ip)*ubar(ip)*hv(ip)+pv2(ip,0)
            weigh(ip)=c1
 180     continue
c
#ifdef bctest2
c-----------------------------------------------------------------------
c  Construct Dirichlet BCs from RHS
c-----------------------------------------------------------------------
c
         if (psurf.eq.1) call psrfbdy (pv2,pv1)
c
#endif
c-----------------------------------------------------------------------
c Compute  RHS: ZTD= cos(lat_u) div(PV1,pv2)
c     PV=-Int_Hv^0 GRAD PI DZ -f[-V,U]
c-----------------------------------------------------------------------
c
c  [DXX,DYY]= [grid-east,grid-north] spacing (cm) and WEIGH=cos(lat_u)
c    
         if(coord.eq.0)then
            dxx=dx
            dyy=dy
         else
            dxx=dx*deg2cm
            dyy=dy*deg2cm
         endif

         do 250 ip=1,jm*im
            weigh(ip)=vmetx(ip)/vmety(ip)
 250     continue
c
#ifdef coast
         call div(im,jm,lseg,dxx,dyy,weigh,isp,iep,pv1,pv2,ztd)
#else
         call div(im,jm,dxx,dyy,weigh,pv1,pv2,ztd)
#endif
c           
c-----------------------------------------------------------------------
c  Get the Dirichlet (if any) boundary conditions.
c-----------------------------------------------------------------------
c
         do 210 j=1,jm
            do 200 i=1,im
               ip=i+(j-1)*im
               if(i.eq.1) pbaroW(j)=pbar(ip)
               if(i.eq.im) pbaroE(j)=pbar(ip)
               if(j.eq.1) pbaroS(i)=pbar(ip)
               if(j.eq.jm) pbaroN(i)=pbar(ip)
 200        continue
 210     continue
c
c Fill interior wet points of PWORK with first guess (PBAR)
c
         call init_pbar(pwork,pbar,im,jm
#ifdef coast
     *                  ,lseg,isp,iep
#endif
     *                  )
c
c-----------------------------------------------------------------------
c  Get boundary conditions and fill-in the working array.
c-----------------------------------------------------------------------
c
c  Update the time change  at the southern and  northern boundaries.
c
         do 220 i=1,im
            pwork(i)=pbaroS(i)
            ip=i+(jm-1)*im
            pwork(ip)=pbaroN(i)
 220     continue
c
#ifdef cyclic
c
c  Set Cyclic boundary conditions.
c
         do 230 j=1,jm
            ip=(j-1)*im+1
            ip1=(j-1)*im+im-1
            pwork(ip)=pwork(ip1)
            ip=(j-1)*im+im
            ip1=(j-1)*im+2
            pwork(ip)=pwork(ip1)
 230     continue
#else
c
c  Update the time change of stream function at the western and
c  eastern boundaries.
c
         do 240 j=1,jm
            ip=1+(j-1)*im
            pwork(ip)=pbaroW(j)
            ip1=im+(j-1)*im
            pwork(ip1)=pbaroE(j)
 240     continue
#endif
#ifdef testsolver
         write(tst2out) im,jm,km,lseg,dx,dy,coord,deg2cm
         do 280 j=1,jm
            do 270 i=1,im
               ip=i+(j-1)*im
               write(tst5out) vmetx(ip),vmety(ip)
               write(tst4out) hv(ip)
               if(i.eq.1)
     $              write(tst6out) pbaroW(j),pbaroE(j)
               if(j.eq.1)
     $              write(tst7out) pbaroN(i),pbaroS(i)
 270        continue
 280     continue   
#endif
c
         write(stdout,*)
         write(stdout,*)
     $        '==============================================='
         write(stdout,*)
     $        ' Convergence Information for Surface Pressure  '
         write(stdout,*)
     $        '==============================================='
         write(stdout,*)
         write(stdout,*) 
#ifndef solvercg
     $        'Solving the equations with PCG '
#else
     $        'Solving the equations with CG '
#endif
         write(stdout,*)
         write(stdout,*) 'Relative tolerance=',tolrel
         write(stdout,*) 'Absolute tolerance=',tolabs
         write(stdout,*)
#ifdef coast
         call Press_solve(im,jm,lseg,dxx,dyy,
     *          isq,ieq,isp,iep,a,pwork,hvex,ztd,weigh,
#else
         call Press_solve(im,jm,dxx,dyy,a,pwork,hvex,ztd,weigh,
#endif
#ifndef solvercg
     *        ir,ia,ja,am,rp,pspar
#else
     *          wk,np
#endif
#if defined testinversion | defined localfilter
     *                     ,xtest
#endif
     *          )
c
         do 290 ip=1,jm*im
            pbar(ip)=pwork(ip)
 290     continue
c
         write(stdout,900)resini,residu,restarget,mican,maxits
c
      endif
c
#ifdef rmpressmean
# ifdef coast
      call rmmean_pbar(im,jm,lseg,pbar,isp,iep)
# else
      call rmmean_pbar(im,jm,pbar)
# endif
c
#endif
      if(ptype.eq.2.and.in_ageo.eq.2) then
         do 310 j=1,jm
            do 300 i=1,im
               ip=i+(j-1)*im
               pbar(ip)=pbar(ip)+grav*elev(ip)
 300        continue
 310     continue
      endif
c
 900  format (
#ifndef solvercg
     &        'PCG SOLVER'/
#else
     &        ' CG SOLVER'/
#endif
     &        '         Initial residual  ',1pe16.7/
     &        '         Final   residual  ',1pe16.7/
     &        '         Targeted residual ',1pe16.7/
     &        '         Number of iterations ', i10/
     &        '          Max. No. of Iters.  ', i10 )
c
      return
      end
