c
c=======================================================================
c  Include file "curflds.h".
c=======================================================================
#ifndef rmdocinc
c
c  Read and/or computed (current) fields to time DCUR.
c
c  DCUR     current time (Julian day or year day).
c  DWDZ     vertical gradient of QG vertical velocity.
c  ELEV     surface elevation
c  K_AGEO   z-grid size of ageostrophic fields at input.
c  M_AGEO   x-grid size of ageostrophic fields at input.
c  N_AGEO   y-grid size of ageostrophic fields at input.
c  PBAR     vertically integrated streamfunction (barotropic transport).
# ifdef surfpress
c           and also surface pressure (defined in baro_velocity).
c  P_BRY    PE pressure boundary conditions.
c  POTENG   Potential Energy with respect to the mean free surface.
# else
c  P_BRY    PE transport streamfuntion boundary conditions.
# endif
c  PSI      velocity streamfunction.
c  T        tracer type of variables (temperature, salinity, other).
c  TMEAN    Slowly varying (horizontally averaged) tracer field.
c  U        total u-velocity component.
c  UAGEO    ageostrophic u-velocity component.
c  UBAR     vertically integrated, total u-velocity component.
# ifdef surfpress
c  UFLAT    total u-velocity component (flat levels)
# endif
c  UI       internal mode (baroclinic) u-velocity component.
c  V        total v-velocity component.
c  VAGEO    ageostrophic v-velocity component.
c  VBAR     vertically integrated, total v-velocity component.
# ifdef surfpress
c  VFLAT    total u-velocity component (flat levels)
# endif
c  VI       internal mode (baroclinic) v-velocity component.
c
c=======================================================================
#endif
c
      common /curflds/ dcur,t,tmean,psi,pbar,u,ubar,ui,v,vbar,vi,dwdz,
     &                 p_bry,uageo,vageo,elev
#ifdef surfpress
     &                 ,uflat,vflat,poteng
#endif
      real dcur,dwdz(np,nz),pbar(np),p_bry(mx,4),psi(np,nz),t(np,nz,mt),
     &     tmean(np,nz,mt),u(np,nz),ubar(np),ui(np,nz),v(np,nz),
     &     vbar(np),vi(np,nz),elev(np),uageo(np,nz),vageo(np,nz)
#ifdef surfpress
     &    ,uflat(np,nz),vflat(np,nz)
     &    ,poteng(np)
#endif
      common /icurflds/m_ageo,n_ageo,k_ageo
      integer m_ageo,n_ageo,k_ageo

