#ifdef coast
      subroutine div(im,jm,lseg,dx,dy,cos_latu,isn,ien,pv1,pv2,ztd)
#else
      subroutine div(im,jm,dx,dy,cos_latu,pv1,pv2,ztd)
#endif
c
c=======================================================================
c 
c    This subroutine assembles the divergence of the vector (PV1,PV2)=== 
c    into ZTD.                                                       ===
#ifdef coast
c    Wet points in the j-th row are the ranges of [isn(j,.):ien(j,:)]===
c    ZTD is zet to zero at dry points.                               ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iend,im,istr,j,jm
#ifdef coast
     &        ,l,lseg
      integer ien(jm,lseg),isn(jm,lseg)
#endif
      real c0,c1,dx,dxi,dy,dyi,fluxhori,fluxhorie,fluxhoriw,fluxvert,
     &     fluxverts,fluxvertn,p5
      real cos_latu(im,jm),pv1(im,jm),pv2(im,jm),ztd(im,jm)
c    
      parameter(c0=0.0,p5=0.5,c1=1.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      dyi=c1/dy
      dxi=c1/dx
c
      do 20 j=1,jm
         do 10 i=1,im
            ztd(i,j)=c0
 10      continue
 20   continue

      do 50 j=2,jm-1
c
#ifdef coast
c  Choose to compute at sea points only and avoid land points
c
         do 40 l=1,lseg
            istr=isn(j,l)
            if(istr.eq.0) go to 50
            iend=ien(j,l)
#else
            istr=2
            iend=im-1
#endif
        do 30 i=istr,iend
c
           fluxhorie=p5*(pv1(i,j)+pv1(i,j-1))
           fluxhoriw=p5*(pv1(i-1,j)+pv1(i-1,j-1))
           fluxhori=(fluxhorie-fluxhoriw)*dxi
c
           fluxvertn=p5*cos_latu(i,j)*(pv2(i,j)+pv2(i-1,j))
           fluxverts=p5*cos_latu(i,j-1)*(pv2(i,j-1)+pv2(i-1,j-1))
           fluxvert=(fluxvertn-fluxverts)*dyi
c
           ztd(i,j)=(fluxhori+fluxvert)
c
 30     continue
 40   continue
 50   continue
c
      return
      end
