      subroutine fdiagn(f,ixm,im,jm,ifield,level,day)
c
c=======================================================================
c                                                                    ===
c  Given a field F, this routine searches for its minimum FMIN and   ===
c  maximum FMAX values  and  computes the mean FAVG, the root mean   ===
c  square FRMS, the average deviation FADV, the standard deviation   ===
c  FSDV, the variance FVAR, the skewness FSKW, and kurtosis FKUR.    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fdiag.h>
#include <iounits.h>
#include <pefldid.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ifield,im,imax,imin,ip,ixm,j,jm,jmax,jmin,lenstr,level,
     *        npts
      integer lnblk
      real c0,c1,day,famx,fscl,fval,p,s,sscl,spval1,spval2,svscl
      real f(*)
      parameter (c0=0.0,c1=1.0,spval1=0.99e+35,spval2=1.0e+35,
     *           svscl=1.0e-12)
      character*80 field
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      fmin=spval2
      imin=1
      jmin=1
      fmax=-spval2
      imax=1
      jmax=1
c
c  If transport streamfunction, scale to Sverdrups.
c
      fscl=c1
      if(ifield.eq.pepbar) fscl=svscl
c
c  Compute the mean and get minimum and maximum values.
c
      npts=0
      favg=c0
      do 20 j=1,jm
        do 10 i=1,im
          ip=i+(j-1)*ixm
          fval=f(ip)*fscl
          if(f(ip).lt.spval1) then
            if(fval.lt.fmin) then
              fmin=fval
              imin=i
              jmin=j
            endif
            if(fval.gt.fmax) then
              fmax=fval
              imax=i
              jmax=j
            endif
            npts=npts+1
            favg=favg+fval
          endif
  10    continue
  20  continue
      if(npts.ne.0) favg=favg/float(npts)
c
c  Compute the root mean square (FRMS), average deviation (FADV),
c  standard deviation (FSDV), variance (FVAR), skewness (FSKW), and
c  kurtosis (FKUR).
c
      frms=c0
      fadv=c0
      fvar=c0
      fskw=c0
      fkur=c0
      npts=0
c
      famx = max( abs(fmin), abs(fmax) )
      if (famx.gt.c1) then
         sscl = c1/famx
       else
         sscl = c1
      end if
c
      do 40 j=1,jm
        do 30 i=1,im
          ip=i+(j-1)*ixm
          if(f(ip).lt.spval1) then
            npts=npts+1
            fval=f(ip)*fscl*sscl
            frms=frms+fval*fval
            s=fval-favg*sscl
            fadv=fadv+abs(s)
            p=s*s
            fvar=fvar+p
            p=p*s
            fskw=fskw+p
            p=p*s
            fkur=fkur+p
          endif
  30    continue
  40  continue
      if(npts.gt.1) then
        frms=sqrt(frms/float(npts))/sscl
        fadv=fadv/float(npts)/sscl
        fvar=fvar/float(npts-1)
        fsdv=sqrt(fvar)
        if(abs(fskw/spval2).lt.abs(float(npts)*fsdv**3)) then
          fskw=fskw/(float(npts)*fsdv**3)
        else
          fskw=spval2
        endif
        if(abs(fkur/spval2).lt.abs(float(npts)*fvar**2)) then
          fkur=fkur/(float(npts)*fvar**2)-3.
        else
          fkur=spval2
        endif
        fvar=fvar/sscl/sscl
        fsdv=fsdv/sscl
      else
        favg=spval2
        frms=spval2
        fadv=spval2
        fvar=spval2
        fsdv=spval2
        fskw=spval2
        fkur=spval2
      endif
c
c  Set field ID string.
c
      if(ifield.eq.peimag) then
        field='internal mode, velocity vector magnitude (cm/s)'
      elseif(ifield.eq.peuhat) then
        field='zonal velocity component (cm/s)'
      elseif(ifield.eq.pevhat) then
        field='meridional velocity component (cm/s)'
#ifdef surfpress
      elseif(ifield.eq.peubar) then
        field='zonal barotropic velocity component (cm/s)'
      elseif(ifield.eq.pevbar) then
        field='meridional barotropic velocity component (cm/s)'
#endif
      elseif(ifield.eq.pewvsv) then
        field='vertical velocity at the velocity points (cm/s)'
      elseif(ifield.eq.pepbar) then
        field='transport streamfunction (Sverdrups)'
#ifdef surfpress
      elseif(ifield.eq.pesfpr) then
        field='surface pressure (dyne/cm^2)'
#endif
      elseif(ifield.eq.petemp) then
        field='temperature (deg C)'
      elseif(ifield.eq.pesalt) then
        field='salinity (PSU)'
      elseif(ifield.eq.pewvzt) then
        field='vertical velocity at the tracer points (cm/s)'
      elseif(ifield.eq.pedano) then
        field='density anomaly (sigma-1000) g/cm^3'
      elseif(ifield.eq.pebtht) then
        field='bathymetry (cm) at the tracer points'
      elseif(ifield.eq.pebthv) then
        field='bathymetry (cm) at the velocity points'
      elseif(ifield.eq.peuoer) then
        field='observation error for zonal velocity'
      elseif(ifield.eq.pevoer) then
        field='observation error for meridional velocity'
#ifdef surfpress
      elseif(ifield.eq.peubor) then
        field='observation error for zonal barotropic velocity'
      elseif(ifield.eq.pevbor) then
        field='observation error for meridional barotropic velocity'
#endif
      elseif(ifield.eq.pepoer) then
        field='observation error for transport streamfunction'
#ifdef surfpress
      elseif(ifield.eq.pesfor) then
        field='observation error for surface pressure'
#endif
      elseif(ifield.eq.petoer) then
        field='observation error for temperature'
      elseif(ifield.eq.pesoer) then
        field='observation error for salinity'
#ifdef bioDuse
cjad   This code needs to be cleaned up...  should use indices not absolutes
cjad     here, to make this more robust and less error prone.
      elseif(ifield.eq.petrc3) then
        field='nitrate (umoles/l)'
      elseif(ifield.eq.pet3oe) then
        field='observation error for nitrate'
      elseif(ifield.eq.petrc4) then
        field='cellnitrate (umoles/l)'
      elseif(ifield.eq.pet4oe) then
        field='observation error for cellnitrate'
      elseif(ifield.eq.petrc5) then
        field='zooplankton (umoles/l)'
      elseif(ifield.eq.pet5oe) then
        field='observation error for zooplankton'
      elseif(ifield.eq.petrc6) then
        field='ammonium (umoles/l)'
      elseif(ifield.eq.pet6oe) then
        field='observation error for ammonium'
      elseif(ifield.eq.petrc7) then
        field='detritus (umoles/l)'
      elseif(ifield.eq.pet7oe) then
        field='observation error for detritus'
      elseif(ifield.eq.petrc8) then
        field='chlorophyll (mg m-3)'
      elseif(ifield.eq.pet8oe) then
        field='observation error for chlorophyll'
      elseif(ifield.eq.petrc9) then
        field='cellammonium (umoles/l)'
      elseif(ifield.eq.pet9oe) then
        field='observation error for cellammonium'
#else
      elseif(ifield.eq.petrc1) then
        field='phytoplankton (umoles/l)'
      elseif(ifield.eq.pet1oe) then
        field='observation error for phytoplankton'
      elseif(ifield.eq.petrc2) then
        field='zooplankton (umoles/l)'
      elseif(ifield.eq.pet2oe) then
        field='observation error for zooplankton'
      elseif(ifield.eq.petrc3) then
        field='nitrate (umoles/l)'
      elseif(ifield.eq.pet3oe) then
        field='observation error for nitrate'
      elseif(ifield.eq.petrc4) then
        field='ammonium (umoles/l)'
      elseif(ifield.eq.pet4oe) then
        field='observation error for ammonium'
      elseif(ifield.eq.petrc5) then
        field='detritus (umoles/l)'
      elseif(ifield.eq.pet5oe) then
        field='observation error for detritus'
#endif
      endif
      lenstr=lnblk(field,len(field))
c
      write(stdout,50) day,field(1:lenstr),level,npts,fmin,imin,jmin,
     *                 fmax,imax,jmax,favg,frms,fadv,fvar,fsdv,fskw,fkur
  50  format(/,'  Field Diagnostics:',/,
     *       /,10x,'                Day = ',f10.3,
     *       /,10x,'         Field type = ',a,
     *       /,10x,'        Model level = ',i5,
     *       /,10x,'   Number of points = ',i5,
     *       /,10x,'            Minimum = ',1pe15.8,
     *          5x,'( ', i3, ',', i3, ' )',
     *       /,10x,'            Maximum = ',1pe15.8,
     *          5x,'( ', i3, ',', i3, ' )',
     *       /,10x,'               Mean = ',1pe15.8,
     *       /,10x,'                RMS = ',1pe15.8,
     *       /,10x,'  Average Deviation = ',1pe15.8,
     *       /,10x,'           Variance = ',1pe15.8,
     *       /,10x,' Standard Deviation = ',1pe15.8,
     *       /,10x,'           Skewness = ',1pe15.8,
     *       /,10x,'           Kurtosis = ',1pe15.8,/)
c
#ifdef sunflush
      call flush(stdout)
c
#endif
      return
      end
