      subroutine filter(zz,im,m,n,nord)
c
c=======================================================================
c                                                                    ===
c  Alternate Directions Shapiro filter.                              ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c         ZZ      field to be filtered                               ===
c         IM      first dimension of zz in the calling program       ===
c         M       number of points in the x-direction                ===
c         N       number of points in the y-direction                ===
c         NORD    order of the Shapiro filter                        ===
c                                                                    ===
c     On Output:                                                     ===
c                                                                    ===
c         ZZ      filtered field                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,idown,im,iodev,ip,iup,j,kord,m,n,nord
#ifdef cyclic
      integer mwk
#endif
      real fac
      real zz(*),g(0:mx+mx+1,0:1)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      iup=1
      iodev=(nord+1)/2-nord/2
      fac=-1.+2.*float(iodev)
      fac=fac/2.**(2*nord)
c
c     Filter by rows
c
      do 5 j=1,n
#ifndef cyclic
        do 1 i=1,m
          ip=i+(j-1)*im
          g(i,iup)=zz(ip)
   1    continue
#else
        mwk = 0
        do 1 i=2,m-1
          ip=i+(j-1)*im
          mwk = mwk + 1
          g(mwk,iup)=zz(ip)
   1    continue
#endif
        do 3 kord=1,nord
#ifndef cyclic
          g(0,iup)=g(2,iup)
          g(m+1,iup)=g(m-1,iup)
          idown=1-iup
          do 2 i=1,m
#else
          g(0,iup)=g(mwk,iup)
          g(mwk+1,iup)=g(1,iup)
          idown=1-iup
          do 2 i=1,mwk
#endif
            g(i,idown)=-2.0*g(i,iup)+g(i+1,iup)+g(i-1,iup)
   2      continue
          iup=1-iup
   3    continue
#ifndef cyclic
        do 4 i=1,m
          ip=i+(j-1)*im
          zz(ip)=zz(ip)+fac*g(i,iup)
   4    continue
#else
        mwk = 0
        do 4 i=2,m-1
          ip=i+(j-1)*im
          mwk = mwk + 1
          zz(ip)=zz(ip)+fac*g(mwk,iup)
   4    continue
#endif
   5  continue
c
c     Filter by columns
c
#ifndef cyclic
      do 10 i=1,m
#else
      do 10 i=2,m-1
#endif
        do 6 j=1,n
          ip=i+(j-1)*im
          g(j,iup)=zz(ip)
   6    continue
        do 8 kord=1,nord
          g(0,iup)=g(2,iup)
          g(n+1,iup)=g(n-1,iup)
          idown=1-iup
          do 7 j=1,n
            g(j,idown)=-2.0*g(j,iup)+g(j+1,iup)+g(j-1,iup)
   7      continue
          iup=1-iup
   8    continue
        do 9 j=1,n
          ip=i+(j-1)*im
          zz(ip)=zz(ip)+fac*g(j,iup)
   9    continue
  10  continue
#ifdef cyclic
c
c  Impose cyclic conditions.
c
      do 11 j=1,n
        ip     = 1+(j-1)*m
        mwk    = (m-1)+(j-1)*m
        zz(ip) = zz(mwk)
        ip     = m+(j-1)*m
        mwk    = 2+(j-1)*m
        zz(ip) = zz(mwk)
  11  continue
#endif
      return
      end
