      subroutine grad_ts (imt,jmt,np,dx,dy,wrk,vmetx,vmety,weigh,
     *                    pv1,pv2)
c
c=======================================================================
c                                                                    ===
c  This subroutine calculates the gradients of quantities preserved  ===
c  at T-S points at velocity points.                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
        integer imt,jmt,np,i,j,ip
        real    wrk(np),vmetx(np),vmety(np),pv1(np),pv2(np),
     *          weigh(np),dx,dy,p5
        parameter(p5=0.5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
        do 10 j=1,jmt-1
          do 20 i=1,imt-1
             ip=i+(j-1)*imt
             pv1(ip)=weigh(ip)*p5*((wrk(ip+1)+wrk(ip+imt+1))-(wrk(ip)
     *              +wrk(ip+imt)))/(dx*vmetx(ip))
             pv2(ip)=weigh(ip)*p5*((wrk(ip+imt)+wrk(ip+imt+1))-(wrk(ip)
     *              +wrk(ip+1)))/(dy*vmety(ip))
 20       continue
 10    continue
c
        do 40 i=1,imt
          ip=(jmt-1)*imt+i
          pv1(ip)=pv1(ip-imt)+(pv1(ip-imt)-pv1(ip-2*imt))
          pv2(ip)=pv2(ip-imt)+(pv2(ip-imt)-pv2(ip-2*imt))
  40    continue
#ifdef cyclic
c
c  Set Cyclic boundary conditions.
c
        do 50 j=1,jmt
          ip=(j-1)*imt
          pv1(1  +ip)=pv1(imt-1+ip)
          pv2(1  +ip)=pv2(imt-1+ip)
          pv1(imt+ip)=pv1(2   +ip)
          pv2(imt+ip)=pv2(2   +ip)
 50     continue
#else
c
c  Extrapolate to outer boundary
c
        do 50 j=1,jmt
          ip=j*imt
          pv1(ip)=pv1(ip-1)+(pv1(ip-1)-pv1(ip-2))
          pv2(ip)=pv2(ip-1)+(pv2(ip-1)-pv2(ip-2))
  50    continue
#endif
c
       return
       end
