c
c=======================================================================
c  Include file "iounits.h".
c=======================================================================
#ifndef rmdocinc
c
c  EXTINP    input unit for barotropic data.
c  FNAME     input/output filenames.
c            FNAME(1)  output; NetCDF fields to be read by the PE model.
c            FNAME(2)  output; diagnostic information for processed 
c                              fields (echo file).
c            FNAME(3)  input; hexadecimal fields to be processed.
c            FNAME(4)  input; mean T-S profile.
c            FNAME(5)  input; GRIDS output file.
c            FNAME(6)  input; transport around islands.
c            FNAME(7)  input; additional tracer fields.
c            FNAME(8)  input; external velocities and transport boundary
c                             conditions.
c            FNAME(9)  input; Reference surface (for dyn. ht.)  (netCDF)
c            FNAME(10)  input; Ageostrophic velocity, elevation (ascii)
c  AGEOINP   input unit for Ageostrophic velocity, elevation.
c  HEXINP    input unit for data in hexadecimal format.
c  ISLINP    input unit for transport around islands and open segments.
c  NAMELEN   length of FNAME (number of characters allocated)
c  MTSINP    input unit for mean TS profile.
c  STDINP    standard input unit.
c  STDOUT    standard output unit.
c  TRCINP    input unit for additional tracer in hexadecimal format.
# ifdef surfpress
c  TST2out   output unit for solver test
c  TST3out   output unit for solver test
c  TST4out   output unit for solver test
c  TST5out   output unit for solver test
c  TST6out   output unit for solver test
c  TST7out   output unit for solver test
c  TST8out   output unit for solver test
c  TST9out   output unit for solver test
c  TST10out  output unit for solver test
c  TST11out  output unit for solver test
# endif
c
c=======================================================================
#endif
c
      integer extinp,hexinp,islinp,mtsinp,stdinp,stdout,
     *                  trcinp,ageoinp
#ifdef surfpress
     *                  ,tst2out,tst3out,tst4out,tst5out,tst6out
     *                  ,tst7out,tst8out,tst9out,tst10out,tst11out
#endif
      common /iiounits/ stdinp,stdout,hexinp,islinp,mtsinp,trcinp,
     *                  extinp,ageoinp
#ifdef surfpress
     *                  ,tst2out,tst3out,tst4out,tst5out,tst6out
     *                  ,tst7out,tst8out,tst9out,tst10out,tst11out
#endif
c
      character*80            fname(10)
      common       /ciounits/ fname
