      subroutine mskind (im,jm,km,lseg,landt,isz,iez,isq,ieq,isp,iep,
     *                   hvex,fkmz,fkmp,fkmq)
c
c=======================================================================
c                                                                    ===
c  This routine sets boundary indicators auxiliary arrays.           ===
c                                                                    ===
c  Calls:     EXITUS                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include<iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,j,jm,km,l,lseg,lsegp,n,on
      integer fkmp(im,jm),fkmq(im,jm),fkmz(im,jm),iep(jm,lseg),
     *        ieq(jm,lseg),iez(jm,lseg),isp(jm,lseg),isq(jm,lseg),
     *        isz(jm,lseg),landt(im,jm)
      real c0,c1,hvweigh
      real hvex(im,jm)
      parameter(c0=0.0,c1=1.0)
c
c=======================================================================
c  Set maximum level indicators for topography.
c=======================================================================
c
      do 100 j=1,jm
      do 100 i=1,im
        fkmp(i,j)=0
        fkmq(i,j)=0
        fkmz(i,j)=0
#ifdef testsolver
        write(tst3out) landt(i,j)
#endif
 100  continue
#ifdef coast
c
c  1st, set number of vertical levels for T points.  At input the
c  land/sea descriptor array LANDT has value 1 at sea points.
c
      do 110 j=1,jm
      do 110 i=1,im
        if(landt(i,j).eq.1) fkmp(i,j)=km
 110  continue
#else
c
c  1st, set number of vertical levels for T points.
c
      do 110 j=1,jm
      do 110 i=1,im
        fkmp(i,j)=km
 110  continue
#endif
c
c  2nd, compute number of vertical levels at each U,V point.
c
      do 120 j=1,jm-1
      do 120 i=1,im-1
        fkmq(i,j)=min(fkmp(i,j),fkmp(i+1,j),fkmp(i,j+1),fkmp(i+1,j+1))
 120  continue
      do 130 j=1,jm
        fkmq(im,j)=fkmq(im-1,j)
 130  continue
      do 140 i=1,im
        fkmq(i,jm)=fkmq(i,jm-1)
 140  continue
c
      do 150 j=2,jm
      do 150 i=2,im
        fkmz(i,j)=min(fkmq(i-1,j-1),fkmq(i,j-1),fkmq(i-1,j),fkmq(i,j))
 150  continue
      do 160 j=1,jm
        fkmz(1,j)=fkmz(2,j)
 160  continue
      do 170 i=1,im
        fkmz(i,1)=fkmz(i,2)
 170  continue
c
c-----------------------------------------------------------------------
c  Compute start and end indices at tracer points for stream function
c  calculations or pressure calculations and filters.
c-----------------------------------------------------------------------
c
      do 171 j=1,jm
        do 171 l=1,lseg
          isp(j,l)=0
          iep(j,l)=0
 171  continue
c
      do 172 j=2,jm-1
        l=0
        on=0
        do 173 i=2,im-1
c
          if(on.eq.0.and.landt(i,j).gt.0) then
            on=1
            l=l+1
            if(l.gt.lseg) then
              write(stdout,900) 'LSEG = ',lseg
              call exitus('BDRYINDX')
            endif
            isp(j,l)=i
          endif
c
          if(on.eq.1.and.landt(i,j).eq.0) then
            on=0
            iep(j,l)=i-1
          endif
c
          if(on.eq.1.and.i.eq.im-1) then
            iep(j,l)=i
          endif
c
 173    continue
 172  continue
c
      do 180 n=1,lseg
      do 180 j=1,jm
        isz(j,n)=0
        iez(j,n)=0
 180  continue
      lsegp=lseg+1
      do 190 j=2,jm-1
        l=1
      do 190 i=2,im-1
        if((fkmz(i-1,j).eq.c0).and.(fkmz(i,j).ne.c0)) isz(j,l)=i
#ifndef coast
        if(i.eq.2) isz(j,l)=2
#else
        if((i.eq.2).and.(fkmz(i-1,j).ne.c0).and.(fkmz(i,j).ne.c0))
     *    isz(j,l)=i
#endif
        if((fkmz(i,j).ne.c0).and.(fkmz(i+1,j).eq.c0)) then
          iez(j,l)=i
          l=l+1
        endif
#ifndef coast
        if((i.eq.im-1).and.(fkmz(i+1,j).ne.c0)) iez(j,l)=i
#else
        if((i.eq.im-1).and.(fkmz(i+1,j).ne.c0).and.(fkmz(i,j).ne.c0))
     *    iez(j,l)=i
#endif
        if(l.ge.lsegp) then
          write(stdout,900) 'JSEG = ',lsegp
          call exitus('BDRYINDX')
        endif
 190  continue
c
c-----------------------------------------------------------------------
c  Compute start and end indices at velocity points for filters.
c-----------------------------------------------------------------------
c
      do 280 n=1,lseg
      do 280 j=1,jm
        isq(j,n)=0
        ieq(j,n)=0
 280  continue
      lsegp=lseg+1
      do 290 j=2,jm-2
        l=1
      do 290 i=2,im-2
        if((fkmq(i-1,j).eq.c0).and.(fkmq(i,j).ne.c0)) isq(j,l)=i
#ifndef coast
        if(i.eq.2) isq(j,l)=2
#else
        if((i.eq.2).and.(fkmq(i-1,j).ne.c0).and.(fkmq(i,j).ne.c0))
     *    isq(j,l)=i
#endif
        if((fkmq(i,j).ne.c0).and.(fkmq(i+1,j).eq.c0)) then
          ieq(j,l)=i
          l=l+1
        endif
#ifndef coast
        if((i.eq.(im-2)).and.(fkmq(i+1,j).ne.c0)) ieq(j,l)=i
#else
        if((i.eq.(im-2)).and.(fkmq(i+1,j).ne.c0).and.(fkmq(i,j).ne.c0))
     *    ieq(j,l)=i
#endif
        if(l.ge.lsegp) then
          write(stdout,900) 'JSEG = ',lsegp
          call exitus ('MSKIND')
        endif
 290  continue
c
c-----------------------------------------------------------------------
c  Compute weighted depth at  velocity points
c-----------------------------------------------------------------------
c
      do 315 j=1,jm-1
         do 314 i=1,im-1
            hvweigh=min(fkmq(i,j),1)
            hvex(i,j)=hvex(i,j)*hvweigh
 314     continue
 315  continue
c
 900  format(/' MSKIND - number of segments exceeded, ',a,i4)
c
      return
      end
