      subroutine op1(im,jm,yxmrat,xymrat,guess,residue,xr)
c
c=======================================================================
c                                                                    ===
c  This routine is called successively by CGPOIS to compute the      ===
c  residual of the solution of  Poisson  equation via conjugate      ===
c  gradient method.  The  finite  difference  stencil has  five      ===
c  five (+ or x) points.                                             ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     IM      number of points in the x-direction (integer).         ===
c     JM      number of points in the y-direction (integer).         ===
c     YXMRAT  the ratio of the y-metric terms over the x-metric      ===
c             terms XYMRAT(i,j) evaluated at (i+1/2, j+1/2).         ===
c     XYMRAT  the ratio of the x-metric terms over the y-metric      ===
c             terms XYMRAT(i,j) evaluated at (i+1/2, j+1/2).         ===
c     GUESS   current guess solution (real array).                   ===
c     XR      forcing field (interior and boundary conditions)       ===
c             (real array).                                          ===
c                                                                    ===
c  On Ouput:                                                         ===
c                                                                    ===
c     RESIDUE current solution residual.                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,ip,j,jm
      real c0,p25,val
      real guess(im,jm),residue(im,jm),xr(im,jm),xymrat(im,jm),
     *     yxmrat(im,jm)
      parameter (c0=0.0,p25=0.25)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef cyclic
c-----------------------------------------------------------------------
c  Impose periodic boundary conditions.
c-----------------------------------------------------------------------
c
      do 5 j = 1, jm
         xr(1, j) = guess(im-1,j)
         xr(im,j) = guess(2   ,j)
   5  continue
c
#endif
c-----------------------------------------------------------------------
c  Five point, TIMES (X) stencil.
c-----------------------------------------------------------------------
c
c  Compute residual at the interior points.
c
      do 20 j=3,jm-2
        do 10 i=3,im-2
          ip=i+(j-1)*im
          if (csmask(ip).eq.0) then
            val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                                (guess(i+1,j  )-guess(i  ,j  )))
     *              -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                                (guess(i  ,j  )-guess(i-1,j  ))))
     *         +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                                (guess(i+1,j-1)-guess(i  ,j-1)))
     *              -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                                (guess(i  ,j-1)-guess(i-1,j-1))))
     *         +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                                (guess(i  ,j+1)-guess(i  ,j  )))
     *              -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                                (guess(i  ,j  )-guess(i  ,j-1))))
     *         +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                                (guess(i-1,j+1)-guess(i-1,j  )))
     *              -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                                (guess(i-1,j  )-guess(i-1,j-1))))
            residue(i,j)=val-xr(i,j)
          else
            residue(i,j)=c0
          endif
  10    continue
  20  continue
c
c  Compute residual near the southern and northern boundaries.
c
      j=2
      do 30 i=3,im-2
        ip=i+(j-1)*im
        if (csmask(ip).eq.0) then
          val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-xr   (i+1,j-1))+
     *                              (guess(i  ,j  )-xr   (i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (guess(i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                              (guess(i-1,j  )-xr   (i-1,j-1))))
          residue(i,j)=val-xr(i,j)
        else
          residue(i,j)=c0
        endif
  30  continue
c
      j=jm-1
      do 40 i=3,im-2
        ip=i+(j-1)*im
        if (csmask(ip).eq.0) then
          val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (guess(i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (guess(i  ,j-1)-guess(i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-guess(i+1,j  ))+
     *                              (xr   (i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                              (xr   (i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (guess(i-1,j  )-guess(i-1,j-1))))
          residue(i,j)=val-xr(i,j)
        else
          residue(i,j)=c0
        endif
  40  continue
c
c  Compute residual near the western and eastern boundaries.
c
      i=2
      do 50 j=3,jm-2
        ip=i+(j-1)*im
        if (csmask(ip).eq.0) then
          val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-xr   (i-1,j+1))+
     *                              (guess(i  ,j  )-xr   (i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (guess(i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                              (guess(i  ,j-1)-xr   (i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (xr   (i-1,j+1)-xr   (i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (xr   (i-1,j  )-xr   (i-1,j-1))))
          residue(i,j)=val-xr(i,j)
        else
          residue(i,j)=c0
        endif
  50  continue
c
      i=im-1
      do 60 j=3,jm-2
        ip=i+(j-1)*im
        if (csmask(ip).eq.0) then
          val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-guess(i  ,j+1))+
     *                              (xr   (i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                              (xr   (i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (guess(i  ,j-1)-guess(i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (guess(i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (guess(i-1,j  )-guess(i-1,j-1))))
          residue(i,j)=val-xr(i,j)
        else
          residue(i,j)=c0
        endif
   60 continue
c
c  Compute residual at the corners.
c
      i=2
      j=2
      ip=i+(j-1)*im
      if (csmask(ip).eq.0) then
        val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                            (guess(i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((guess(i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-xr   (i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                            (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                            (guess(i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((guess(i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-xr   (i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-xr   (i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                            (xr   (i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
      else
        residue(i,j)=c0
      endif
c
      i=2
      j=jm-1
      ip=i+(j-1)*im
      if (csmask(ip).eq.0) then
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                            (guess(i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-xr   (i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                            (guess(i+1,j-1)-guess(i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                            (guess(i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-guess(i+1,j  ))+
     *                            (xr   (i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                            (guess(i  ,j  )-guess(i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-xr   (i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                            (xr   (i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
      else
        residue(i,j)=c0
      endif
c
      i=im-1
      j=2
      ip=i+(j-1)*im
      if (csmask(ip).eq.0) then
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-guess(i  ,j+1))+
     *                            (xr   (i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                            (guess(i  ,j  )-guess(i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                            (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                            (guess(i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-xr   (i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                            (guess(i-1,j+1)-guess(i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                            (guess(i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
      else
        residue(i,j)=c0
      endif
c
      i=im-1
      j=jm-1
      ip=i+(j-1)*im
      if (csmask(ip).eq.0) then
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                            (xr   (i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-guess(i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-guess(i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                            (guess(i  ,j-1)-guess(i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                            (xr   (i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-guess(i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-guess(i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                            (guess(i-1,j  )-guess(i-1,j-1))))
        residue(i,j)=val-xr(i,j)
      else
        residue(i,j)=c0
      endif
      return
      end
