c
c=======================================================================
c  Include file "param.h" for PE_initial.
c=======================================================================
#ifndef rmdocinc
c
c  MCSEG   maximum number of coastal segments.
c  MISLE   maximum number of islands in the model basin.
c  MPROF   maximum number of points in mean TS profile.
c  MPSEG   maximum number of points per coastal segment.
c  MT      maximum number of tracers. Minimum is two for temperature
c          and salinity.
c  MX      maximum number of points in any of the two horizontal
c          dimensions: (MX=max(IM,JM).
c  NP      maximum number of horizontal points (NP=IM*JM).
c  NZ      maximum number of vertical levels.
# ifdef surfpress
c  NMAX    SPARSKIT workspace ~IM*JM (number of rows in Ellip. Matrix)
c  NZMAX   SPARSKIT workspace. ~nmax*2*(fillin+1)
c  LWK     SPARSKIT workspace.
c  IJMX    max of IM and JM
c  ISESIZE  >= LSEG*JMT (LSEG as defined in param.h in PE)
c  LSEG    max of partitions of coastal segments in the x-direction.
# endif
c
c=======================================================================
#endif
c
      integer mcseg,misle,mprof,mpseg,mt,mx,np,nz
      parameter (np=25000,mx=210,mt=2,nz=60,mcseg=20,mpseg=2000,
     *           misle=20,mprof=5000)
#ifdef surfpress
      integer ijmx,isesize,lseg
      parameter (ijmx=mx,lseg=20,isesize=ijmx*lseg)
      integer nmax, nzmax,lwk
      parameter (nmax=np,nzmax=nmax*32,lwk=nmax*40)
#endif
