      subroutine psrfbdy (uish,vish)
c
c=======================================================================
c                                                                    ===
c  This routine makes an initial guess for the boundary conditions   ===
c  along the open boundaries for surface pressure.                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  UISH, VISH.....Chosen forcing "velocities".  (real arrays; cm2/s2)===
c                 (dp/dy, dp/dx)                                     ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c    LANDT........Land mask at tracer points.  (integer array)       ===
c                                                                    ===
c  /GRDDAT/                                                          ===
c                                                                    ===
c    TMETX........X-coordinate metric coefficients at velocity grid  ===
c                   (real array; cm)                                 ===
c    TMETY........Y-coordinate metric coefficients at velocity grid  ===
c                   (real array; cm)                                 ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c    HV...........Bottom depth at velocity points.  (cm)             ===
c                   (input; real array)                              ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    STDOUT.......Standard output unit.  (integer)                   ===
c                                                                    ===
c  /MODDAT/                                                          ===
c                                                                    ===
c    DX, DY.......Grid spacings.  (cm)  (real)                       ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM, KM...Number of grid points in x, y and z directions.    ===
c                   (integers)                                       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    PBAR.........Surface Pressure, reset on                         ===
c                 outer boundary.   (real array)                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer   bndysz
      real      c0,c1,p5,small
      parameter (bndysz=4*mx, c0=0.0, c1=1.0, p5=0.5, small=1.0e-35)
c
      integer i,ibnd,ip,j
      real    atot,pbavg0,tot,veldiff
#if !defined coast | defined bctest1
     &        ,val
#endif
      real    abtrns(bndysz),trnspt(bndysz),uish(np),vish(np)
      real    psibavg
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c        
c-----------------------------------------------------------------------
c     Compute average value of surface pressure along boundary.
c     Keep track of length around outer boundary for correction.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     First pass, set boundary values to get desired normal velocity.
c-----------------------------------------------------------------------
c
      ip       = im
      ibnd     = 0
      pbar(ip) = c0
      atot     = c0
      tot      = c0
c
c  East.
c
      do 10 j = 2, jm
         ip   = j*im
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip-im)).gt.0) then
            trnspt(ibnd) = uish(ip-1-im)/hv(ip-1-im)*
     &                     p5*dy*(tmety(ip)+tmety(ip-im))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip-im) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 10   continue
c
c  North.
c
#ifndef cyclic
      do 20 i = im-1, 1, -1
#else
      do 20 i = im-1, 2, -1
#endif
         ip = i + (jm-1)*im
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip+1)).gt.0) then
            trnspt(ibnd) = - vish(ip-im)/hv(ip-im)*
     &                     p5*dx*(tmetx(ip)+tmetx(ip+1))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip+1) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 20   continue
c
c  West.
c
      do 30 j = jm-1, 1, -1
#ifndef cyclic
         ip = 1 + (j-1)*im
#else
         ip = 2 + (j-1)*im
#endif
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip+im)).gt.0) then
            trnspt(ibnd) = - uish(ip)/hv(ip)*
     &                     p5*dy*(tmety(ip)+tmety(ip+im))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip+im) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 30   continue
c
c  South.
c
#ifndef cyclic
      do 40 i = 2, im-1
#else
      do 40 i = 3, im-1
#endif
         ip = i
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip-1)).gt.0) then
            trnspt(ibnd) = vish(ip-1)/hv(ip-1)*
     &                     p5*dx*(tmetx(ip)+tmetx(ip-1))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip-1) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 40   continue

c
c  Check on closure
c
      ip = im
      ibnd = ibnd + 1
      if((landt(ip)*landt(ip-1)).gt.0) then
         trnspt(ibnd) = vish(ip-1)/hv(ip-1)*
     &                  p5*dx*(tmetx(ip)+tmetx(ip-1))
      else
         trnspt(ibnd) = c0
      end if
      abtrns(ibnd) = abs(trnspt(ibnd))
      tot          = tot + trnspt(ibnd)
      atot         = atot + abtrns(ibnd)
c
c  Compute correction factor
c
      if (small*abs(tot).lt.atot) then
         veldiff = - tot/atot
       elseif (abs(tot).gt.c0) then
         veldiff = - sign(c1/small,tot)
       else
         veldiff = c0
      end if
      write(stdout,200) tot,atot,veldiff
c
#if !defined coast | defined bctest1
c-----------------------------------------------------------------------
c     Add velocity correction (proportional to original velocities) to
c     get zero net surface pressure change along the boundary.
c-----------------------------------------------------------------------
c
c  Update transport through boundaries.
c
      ibnd = 0
      atot = c0
      tot  = c0
c
c  East.
c
      do 50 j = 2, jm
         ip   = j*im
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip-im) + val
         tot      = tot + val
 50   continue
c
c  North.
c
# ifndef cyclic
      do 60 i = im-1, 1, -1
# else
      do 60 i = im-1, 2, -1
# endif
         ip = i + (jm-1)*im
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip+1) + val
         tot      = tot + val
 60   continue
c
c  West.
c
      do 70 j = jm-1, 1, -1
# ifndef cyclic
         ip = 1 + (j-1)*im
# else
         ip = 2 + (j-1)*im
# endif
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip+im) + val
         tot      = tot + val
 70   continue
c
c  South.
c
# ifndef cyclic
      do 80 i = 2, im-1
# else
      do 80 i = 3, im-1
# endif
         ip = i
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip-1) + val
         tot      = tot + val
 80   continue
c
c  Check on closure
c
      ip = im
      ibnd = ibnd + 1
      val  = trnspt(ibnd) + veldiff*abtrns(ibnd)
      tot  = tot + val
c
      pbavg0 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
      write(stdout,300) tot
#else
      pbavg0 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
#endif
      if ((small*abs(tot)).lt.abs(pbavg0)) then
         write(stdout,310) abs(tot)/abs(pbavg0)
      end if
c
#ifdef sunflush
      call flush(stdout)
c
#endif
      return
c
 200  format(/'PSRFBDY:'/
     &       10x,' Initial difference in Surface pressure : ',1pg16.7/
     &       10x,' Surface Pressure at inflow (1st guess) : ',1pg16.7/
     &       10x,'                     Correction factor  : ',1pg16.7)
 300  format(10x,' Final difference in Surface Pressure   : ',1pg16.7)
 310  format(10x,' Relative difference in Surface Pressure: ',1pg16.7)
c
      end
