      subroutine psurfbdy (utop,vtop,fcori)
c
c=======================================================================
c     This routine makes an initial guess for the boundary conditions===
c     along the open boundaries for surface pressure.                ===
c                                                                    ===
c  Input:                                                            ===
c                                                                    ===
c  UTOP, VTOP.....Chosen top velocities. (cm/s)  (input;real arrays) ===
c  FCORI..........Coriolis parameter (1/s)  (input;real arrays)      ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c    LANDT........Land mask at tracer points.  (input; integer array)===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    PBAR.........Surface Pressure, reset on                         ===
c                 outer boundary.   (output; real array)             ===
c                                                                    ===
c  /GRDDAT/                                                          ===
c                                                                    ===
c    TMETX........X-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c    TMETY........Y-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    STDOUT.......Standard output unit.  (input; integer)            ===
c                                                                    ===
c  /MODDAT/                                                          ===
c                                                                    ===
c    DX, DY.......Grid spacings.  (cm)  (input; real)                ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM, KM...Number of grid points in x, y and z directions.    ===
c                   (input; integers)                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer   bndysz
      real      c0,c1,p5,small
      parameter (bndysz=4*mx, c0=0.0, c1=1.0, p5=0.5, small=1.0e-35)
c
      integer i,ibnd,ip,j
      real    atot,pbavg0,tot,veldiff
#if !defined coast | defined bctest1
     &        ,val
#endif
      real    abtrns(bndysz),trnspt(bndysz),utop(np),vtop(np),fcori(np)
      real    psibavg
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c     Compute average value of surface pressure along boundary.
c     Keep track of length around outer boundary for correction.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c     First pass, set boundary values to get desired normal velocity.
c-----------------------------------------------------------------------
c
      ip       = im
      ibnd     = 0
      pbar(ip) = c0
      atot     = c0
      tot      = c0
c
c  East.
c
      do 10 j = 2, jm
         ip   = j*im
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip-im)).gt.0) then
            trnspt(ibnd) = - utop(ip-1-im)*fcori(ip-1-im)*
     &           p5*dy*(tmety(ip)+tmety(ip-im))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip-im) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 10   continue
c
c  North.
c
#ifndef cyclic
      do 20 i = im-1, 1, -1
#else
      do 20 i = im-1, 2, -1
#endif
         ip = i + (jm-1)*im
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip+1)).gt.0) then
            trnspt(ibnd) = - vtop(ip-im)*fcori(ip-im)*
     &           p5*dx*(tmetx(ip)+tmetx(ip+1))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip+1) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 20   continue
c
c  West.
c
      do 30 j = jm-1, 1, -1
#ifndef cyclic
         ip = 1 + (j-1)*im
#else
         ip = 2 + (j-1)*im
#endif
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip+im)).gt.0) then
            trnspt(ibnd) = utop(ip)*fcori(ip)*
     &           p5*dy*(tmety(ip)+tmety(ip+im))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip+im) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 30   continue
c
c  South.
c
#ifndef cyclic
      do 40 i = 2, im-1
#else
      do 40 i = 3, im-1
#endif
         ip = i
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip-1)).gt.0) then
            trnspt(ibnd) = vtop(ip-1)*fcori(ip-1)*
     &           p5*dx*(tmetx(ip)+tmetx(ip-1))
         else
            trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         pbar(ip)     = pbar(ip-1) + trnspt(ibnd)
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
 40   continue

c
c  Check on closure
c
      ip = im
      ibnd = ibnd + 1
      if((landt(ip)*landt(ip-1)).gt.0) then
         trnspt(ibnd) = vtop(ip-1)*fcori(ip-1)*
     &                    p5*dx*(tmetx(ip)+tmetx(ip-1))
      else
         trnspt(ibnd) = c0
      end if
      abtrns(ibnd) = abs(trnspt(ibnd))
      tot          = tot + trnspt(ibnd)
      atot         = atot + abtrns(ibnd)
c
c  Compute correction factor
c
      if (small*abs(tot).lt.atot) then
         veldiff = - tot/atot
       elseif (abs(tot).gt.c0) then
         veldiff = - sign(c1/small,tot)
       else
         veldiff = c0
      end if
      write(stdout,200) tot,atot,veldiff
c
#if !defined coast | defined bctest1
c-----------------------------------------------------------------------
c     Add velocity correction (proportional to original velocities) to
c     get zero net surface pressure change along the boundary.
c-----------------------------------------------------------------------
c
c  Update transport through boundaries.
c
      ibnd     = 0
      atot     = c0
      tot      = c0
c
c  East.
c
      do 50 j = 2, jm
         ip   = j*im
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip-im) + val
         tot      = tot + val
 50   continue
c
c  North.
c
# ifndef cyclic
      do 60 i = im-1, 1, -1
# else
      do 60 i = im-1, 2, -1
# endif
         ip = i + (jm-1)*im
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip+1) + val
         tot      = tot + val
 60   continue
c
c  West.
c
      do 70 j = jm-1, 1, -1
# ifndef cyclic
         ip = 1 + (j-1)*im
# else
         ip = 2 + (j-1)*im
# endif
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip+im) + val
         tot      = tot + val
 70   continue
c
c  South.
c
# ifndef cyclic
      do 80 i = 2, im-1
# else
      do 80 i = 3, im-1
# endif
         ip = i
         ibnd = ibnd + 1
         val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
         pbar(ip) = pbar(ip-1) + val
         tot      = tot + val
 80   continue
c
c  Check on closure
c
      ip = im
      ibnd = ibnd + 1
      val  = trnspt(ibnd) + veldiff*abtrns(ibnd)
      tot  = tot + val
c
      pbavg0 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
      write(stdout,300) tot
#else
      pbavg0 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
#endif
      if ((small*abs(tot)).lt.abs(pbavg0)) then
         write(stdout,310) abs(tot)/abs(pbavg0)
      end if
c
#ifdef sunflush
      call flush(stdout)
c
#endif
c
      return
c
 200  format(/'PSURFBDY:'/
     &       10x,' Initial difference in Surface pressure : ',1pg16.7/
     &       10x,' Surface Pressure at inflow (1st guess) : ',1pg16.7/
     &       10x,'                     Correction factor  : ',1pg16.7)
 300  format(10x,' Final difference in Surface Pressure   : ',1pg16.7)
 310  format(10x,' Relative difference in Surface Pressure: ',1pg16.7)
c
      end
