      subroutine put_init
c
c=======================================================================
c                                                                    ===
c  This routine writes out PE model initial conditions fields or     ===
c  assimilation fields.                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <ndimen.h>
#include <obserr.h>
#include <pefldid.h>
#include <pi_netcdf.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nv
      parameter (nv=np*nz)
c
      integer k,m,t0indx
      integer count(5),start(5)
      real f(nv)
      parameter (t0indx=1)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(job.eq.1) then
        write(stdout,900) 'assimilation',dcur
      else
        write(stdout,900) 'initialization',dcur
      endif
c
c-----------------------------------------------------------------------
c  Advance time counter and write out time.
c-----------------------------------------------------------------------
c
      if(job.eq.1) then
        tindx=tindx+1
        start(1)=tindx
        count(1)=1
        call ncvpt(ncoutid,timeid,start,count,dcur,rcode)
        if(rcode.ne.0) then
          write(stdout,901) 'time'
          call exitus('PUT_INIT')
        endif
      else
        start(1)=t0indx
        count(1)=1
        call ncvpt(ncoutid,time0id,start,count,dcur,rcode)
        if(rcode.ne.0) then
          write(stdout,901) 'time0'
          call exitus('PUT_INIT')
        endif
      endif
c
c-----------------------------------------------------------------------
c  Compute field diagnostics.
c-----------------------------------------------------------------------
c
c  Internal mode velocity.
c
      do 20 k=1,km
        call fdiagn(ui(1,k),im,im,jm,peuhat,k,dcur)
  20  continue
      do 30 k=1,km
        call fdiagn(vi(1,k),im,im,jm,pevhat,k,dcur)
  30  continue
c
c  External mode velocity.
c
      call fdiagn(ubar,im,im,jm,peubar,0,dcur)
      call fdiagn(vbar,im,im,jm,pevbar,0,dcur)
c
c  Transport streamfunction.
c
      if (ptype.eq.0) then
        call fdiagn(pbar,im,im,jm,pepbar,0,dcur)
       else
        call fdiagn(pbar,im,im,jm,pesfpr,0,dcur)
      end if
c
c  Tracers.
c
      do 40 m=1,nt
      do 40 k=1,km
        call fdiagn(t(1,k,m),im,im,jm,tid(m),k,dcur)
#ifdef meantracer
        call fdiagn(tmean(1,k,m),im,im,jm,tmenid(m),k,dcur)
#endif
 40   continue
c
c-----------------------------------------------------------------------
c  Process observation error fields, if appropriate.
c-----------------------------------------------------------------------
c
      if(lwrtoerr.and.(job.eq.1)) then
c
c  Process observation error fields.
c
        call set_oerr(dcur)
c
c  Write error fields ranges.
c
        start(1)=1
#ifndef surfpress
        count(1)=nt+3
#else
        if (ptype.eq.0) then
          count(1)=nt+3
         else
          count(1)=nt+5
        end if
#endif
        start(3)=tindx
        count(3)=1
        do 50 k=1,km
          start(2)=k
          count(2)=1
          call ncvpt(ncoutid,eminid,start,count,oerrmin(1,k),rcode)
          if(rcode.ne.0) then
            write(stdout,902) 'oerrmin',k
            call exitus('PUT_INIT')
          endif
          call ncvpt(ncoutid,emaxid,start,count,oerrmax(1,k),rcode)
          if(rcode.ne.0) then
            write(stdout,902) 'oerrmax',k
            call exitus('PUT_INIT')
          endif
  50    continue
      endif
c
c=======================================================================
c  Write out initial fields or assimilation fields and, if appropriate,
c  observation errors.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write out initial or assimilations fields.
c-----------------------------------------------------------------------
c
c  Write out internal mode velocity.
c
      start(2)=1
      count(2)=km
      start(3)=1
      count(3)=im
      start(4)=1
      count(4)=jm
      if(job.eq.1) then
        start(5)=tindx
        count(5)=1
      else
        start(5)=t0indx
        count(5)=1
      endif
      if(icoast.ne.0) then
        call fsaveu(f,nv,ui,np,nz,im,jm,km)
      else
        call fsave (f,nv,ui,np,nz,im,jm,km)
      endif
      start(1)=xindx
      count(1)=1
      if(job.eq.1) then
        call ncvpt(ncoutid,vobsid,start,count,f,rcode)
      else
        call ncvpt(ncoutid,viniid,start,count,f,rcode)
      endif
      if(rcode.ne.0) then
        write(stdout,903) 'vclin x-component'
        call exitus('PUT_INIT')
      endif
      if(icoast.ne.0) then
        call fsavev(f,nv,vi,np,nz,im,jm,km)
      else
        call fsave (f,nv,vi,np,nz,im,jm,km)
      endif
      start(1)=yindx
      count(1)=1
      if(job.eq.1) then
        call ncvpt(ncoutid,vobsid,start,count,f,rcode)
      else
        call ncvpt(ncoutid,viniid,start,count,f,rcode)
      endif
      if(rcode.ne.0) then
        write(stdout,903) 'vclin y-component'
        call exitus('PUT_INIT')
      endif
c
c  Write out internal mode velocity error fields.
c
      if(lwrtoerr.and.(job.eq.1)) then
        call fsave(f,nv,uoerr,np,nz,im,jm,km)
        start(1)=xindx
        count(1)=1
        call ncvpt(ncoutid,verrid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,903) 'vclinerr x-component'
          call exitus('PUT_INIT')
        endif
        call fsave(f,nv,voerr,np,nz,im,jm,km)
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,verrid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,903) 'vclinerr y-component'
          call exitus('PUT_INIT')
        endif
      endif
c
c  External mode velocity.
c
      if(icoast.ne.0) then
        call fsaveu(f,nv,ubar,np,1,im,jm,1)
      else
        call fsave (f,nv,ubar,np,1,im,jm,1)
      endif
      start(2)=xindx
      count(2)=1
      if(job.eq.1) then
        call ncvpt(ncoutid,vbobid,start(2),count(2),f,rcode)
      else
        call ncvpt(ncoutid,vbinid,start(2),count(2),f,rcode)
      endif
      if(rcode.ne.0) then
        write(stdout,903) 'vbaro x-component'
        call exitus('PUT_INIT')
      endif
c
      if(icoast.ne.0) then
        call fsavev(f,nv,vbar,np,1,im,jm,1)
      else
        call fsave (f,nv,vbar,np,1,im,jm,1)
      endif
      start(2)=yindx
      if(job.eq.1) then
        call ncvpt(ncoutid,vbobid,start(2),count(2),f,rcode)
      else
        call ncvpt(ncoutid,vbinid,start(2),count(2),f,rcode)
      endif
      if(rcode.ne.0) then
        write(stdout,903) 'vbaro y-component'
        call exitus('PUT_INIT')
      endif
      start(2)=1
      count(2)=km
#ifdef surfpress
c
c  Write out external mode velocity error fields.
c
      if(lwrtoerr.and.(job.eq.1).and.(ptype.gt.0)) then
        start(2)=xindx
        count(2)=1
        call ncvpt(ncoutid,vberid,start(2),count(2),ubaroerr,rcode)
        if(rcode.ne.0) then
          write(stdout,903) 'vbaroerr x-component'
          call exitus('PUT_INIT')
        endif
        start(2)=yindx
        call ncvpt(ncoutid,vberid,start(2),count(2),vbaroerr,rcode)
        if(rcode.ne.0) then
          write(stdout,903) 'vbaroerr y-component'
          call exitus('PUT_INIT')
        endif
        start(2)=1
        count(2)=km
      endif
c
#endif
c  Write out Tracers.
c
      start(1)=1
      count(1)=km
      start(2)=1
      count(2)=im
      start(3)=1
      count(3)=jm
      if(job.eq.1) then
        start(4)=tindx
        count(4)=1
      else
        start(4)=t0indx
        count(4)=1
      endif
      do 60 m=1,nt
        call fsave(f,nv,t(1,1,m),np,nz,im,jm,km)
        if(job.eq.1) then
          call ncvpt(ncoutid,tobsid(m),start,count,f,rcode)
        else
          call ncvpt(ncoutid,tiniid(m),start,count,f,rcode)
        endif
        if(rcode.ne.0) then
          write(stdout,904) 'trc',m
          call exitus('PUT_INIT')
        endif
#ifdef meantracer
        if(job.ne.1) then
          call fsave(f,nv,tmean(1,1,m),np,nz,im,jm,km)
          call ncvpt(ncoutid,tmenid(m),start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,904) 'trcmean',m
            call exitus('PUT_INIT')
          endif
        endif
#endif
  60  continue
c
c  Write tracer error fields.
c
      if(lwrtoerr.and.(job.eq.1)) then
        do 70 m=1,nt
          call fsave(f,nv,toerr(1,1,m),np,nz,im,jm,km)
          call ncvpt(ncoutid,terrid(m),start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,904) 'trcerr',m
            call exitus('PUT_INIT')
          endif
  70    continue
      endif
c
c  Write out transport streamfunction.
c
      start(1)=1
      count(1)=im
      start(2)=1
      count(2)=jm
      if(job.eq.1) then
        start(3)=tindx
        count(3)=1
      else
        start(3)=t0indx
        count(3)=1
      endif
      call fsave(f,nv,pbar,np,1,im,jm,1)
      if(job.eq.1) then
        call ncvpt(ncoutid,pobsid,start,count,f,rcode)
      else
        call ncvpt(ncoutid,piniid,start,count,f,rcode)
      endif
      if(rcode.ne.0) then
#ifndef surfpress
        write(stdout,903) 'pbar'
#else
        if (ptype.eq.0) then
          write(stdout,903) 'pbar'
         else
          write(stdout,903) 'srfpress'
        end if
#endif
        call exitus('PUT_INIT')
      endif
c
c  Write out transport streamfunction error field.
c
      if(lwrtoerr.and.(job.eq.1)) then
        call fsave(f,nv,pbaroerr,np,1,im,jm,1)
        call ncvpt(ncoutid,perrid,start,count,f,rcode)
        if(rcode.ne.0) then
#ifndef surfpress
          write(stdout,903) 'pbarerr'
#else
          if (ptype.eq.0) then
            write(stdout,903) 'pbarerr'
           else
            write(stdout,903) 'srfpresserr'
          end if
#endif
          call exitus('PUT_INIT')
        endif
      endif
c
c  Synchronize NetCDF data to disk.
c
      call ncsnc(ncoutid,rcode)
      if(rcode.ne.0) then
        write(stdout,905)
        call exitus('PUT_INIT')
      endif
c
 900  format(/' Writing ',a,' fields for day = ',f12.4,/)
 901  format(/' PUT_INIT - error while writing variable: ',a)
 902  format(/' PUT_INIT - error while writing variable: ',a,2x,
     *        ' at LEVEL = ',i2)
 903  format(/' PUT_INIT - error while writing variable: ',a,2x)
 904  format(/' PUT_INIT - error while writing variable: ',a,2x,
     *        ' at TRACER = ',i2)
 905  format(/' PUT_INIT - unable to synchronize data to disk.')
      return
      end
