#ifndef strmtst
      subroutine read_inputs (im,jm,landt,hv,vmetx,vmety,
#else
      subroutine read_inputs (im,jm,landt,hv,vmetx,vmety,corfac,
#endif
     *                        pbaroS,pbaroN,pbaroW,pbaroE,ztd)
c
c=======================================================================
c                                                                    ===
c  This routine reads the geometric, forcing & boundary condition    ===
c  data needed to tune the pre-conditioner.                          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IM       Number grid points, X-direction.     (integer)        ===
c     JM       Number grid points, Y-direction.     (integer)        ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     TST3OUT   output unit for solver test.        (integer)        ===
c     TST4OUT   output unit for solver test.        (integer)        ===
c     TST5OUT   output unit for solver test.        (integer)        ===
c     TST6OUT   output unit for solver test.        (integer)        ===
c     TST7OUT   output unit for solver test.        (integer)        ===
c     TST8OUT   output unit for solver test.        (integer)        ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     LANDT    Land mask, tracer grid.              (integer array)  ===
c     HV       Topography, velocity grid.           (real array)     ===
c     VMETX    X-metric factors, velocity grid.     (real array)     ===
#ifndef strmtst
c     VMETY    Y-metric factors, velocity grid.     (real array)     ===
#else
c     VMETY    X-metric factors, tracer grid.       (real array)     ===
c     CORFAC   Coriolis factor.                     (real array)     ===
#endif
c     PBAROS   Boundary conditions, southern bndy.  (real vector)    ===
c     PBARON   Boundary conditions, northern bndy.  (real vector)    ===
c     PBAROW   Boundary conditions, western bndy.   (real vector)    ===
c     PBAROE   Boundary conditions, eastern bndy.   (real vector)    ===
c     ZTD      Poisson equation forcing.            (real array)     ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,j,jm
      integer landt(im,jm)
      real    hv(im,jm),pbaroE(jm),pbaroN(im),pbaroS(im),pbaroW(jm),
     &     vmetx(im,jm),vmety(im,jm),ztd(im,jm)
#ifdef strmtst
     &     ,corfac(im,jm)
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read land mask, topography & metric factors.
c-----------------------------------------------------------------------
c
      do 20 j=1,jm
        do 10 i=1,im
#ifdef coast
          read(tst3out) landt(i,j)
#endif
          read(tst4out) hv(i,j)
#ifndef strmtst
          read(tst5out) vmetx(i,j),vmety(i,j)
#else
          read(tst5out) vmetx(i,j),vmety(i,j),corfac(i,j)
#endif
  10    continue
  20  continue      
c
c-----------------------------------------------------------------------
c  Read boundary conditions & forcing.
c-----------------------------------------------------------------------
c
      do 40 j=1,jm
        read(tst6out) pbaroW(j),pbaroE(j)
        do 30 i=1,im
          if(j.eq.1) read(tst7out) pbaroN(i),pbaroS(i)
          read(tst8out) ztd(i,j)
 30     continue
 40   continue      
c
      return
      end
