      subroutine reset_depths
c
c=======================================================================
c                                                                    ===
c  This routine sets the depths at the tracers (T,S)  and velocity   ===
c  (u,v) points. These depths are used to interpolate these fields   ===
c  to hybrid (topography-following) coordinates.                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
#include <curflds.h>
#ifdef sunflush
#include <iounits.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j
      real p25,grav,fac1,c1
      parameter (p25=0.25,grav=981.0,c1=1.0)
      real etav(np),etat(np)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c
c  Set free surface at the T points.
c
      fac1=c1/grav
      do 100 ip=1,im*jm
         etat(ip)=fac1*pbar(ip)
 100  continue

c
c  Set free surface at the U-V points.
c
      do 130 j=1,jm-1
        do 120 i=1,im-1
          ip=i+(j-1)*im
          etav(ip)=p25*(etat(ip)+etat(ip+1)+etat(ip+im)+etat(ip+im+1))
 120    continue
#ifdef cyclic
        ip=(j-1)*im
        etav(ip+1 )=etav(ip+im-1)
        etav(ip+im)=etav(ip+2)
#else
        ip=j*im
        etav(ip)=etav(ip-1)
#endif
 130  continue
      do 140 i=1,im
        ip=i+(jm-1)*im
        etav(ip)=etav(ip-im)
 140  continue

c
c-----------------------------------------------------------------------
c  Set the depths of each tracer and velocity point.
c-----------------------------------------------------------------------
c
      call reset_vgrid(etat,etav,np)
c
      call check_depths
c
#ifdef sunflush
      call flush(stdout)
c
#endif
      return
      end


