      subroutine reset_vgrid (etat,etav,nlen)
c
c=======================================================================
c                                                                    ===
c  This subroutine resets the depths of each tracer and velocity grid===
c  point in the hybrid (single or double transformation) coordinate  ===
c  system:                                                           ===
c                                                                    ===
c     Common Blocks: (only relevant variables listed)                ===
c                                                                    ===
c     /HYBRID/                                                       ===
c                                                                    ===
c     DEPTHMT   the depths (cm) at the middle of the tracer boxes    ===
c               (output; real array)                                 ===
c     DEPTHMV   the depths (cm) at the middle of the velocity boxes  ===
c               (output; real array)                                 ===
c     KP        coordinate interface level (input; integer)          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nlen
      real etav(nlen),etat(nlen)
      integer ip,k,km1
      real 
     *     sigmt,sigmv,zdzt,zdzv,zdt,zdv,c2,p5,dpt,dpv
      parameter(c2=2.0,p5=0.5)
c
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c
c-----------------------------------------------------------------------
c  Deform all levels
c-----------------------------------------------------------------------
      kp=km
      do 30 ip=1,im*jm
c
c-----------------------------------------------------------------------
c  In upper deformable sigma system (k<=kp) reset depths
c  from depths measured from the  mean sea level
c-----------------------------------------------------------------------
c
         zdzv=depthfv(ip,1)
         zdv=c2*zdzv
         zdzt=depthft(ip,1)
         zdt=c2*zdzt
c
c-----------------------------------------------------------------------
c  Find depth of interface dpt and dpv between levels kp-1 and kp
c-----------------------------------------------------------------------
c
#ifndef barotropic
         do 10 k=2,kp
            km1=k-1
            zdzv=depthfv(ip,k)-depthfv(ip,km1)
            zdv=c2*zdzv-zdv
            zdzt=depthft(ip,k)-depthft(ip,km1)
            zdt=c2*zdzt-zdt
 10      continue
#endif
         dpv=depthfv(ip,kp)+p5*zdv
         sigmv=(dpv+etav(ip))/dpv
         dpt=depthft(ip,kp)+p5*zdt
         sigmt=(dpt+etat(ip))/dpt
         do 20 k=1,kp
            depthmt(ip,k)=depthft(ip,k)*sigmt-etat(ip)
            depthmv(ip,k)=depthfv(ip,k)*sigmv-etav(ip)
 20      continue
 30   continue
      return
      end

