      subroutine setdepths
c
c=======================================================================
c                                                                    ===
c  This routine sets the depths at the tracers (T,S)  and velocity   ===
c  (u,v) points. These depths are used to interpolate these fields   ===
c  to hybrid (topography-following) coordinates.                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <iounits.h>
#include <ndimen.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real       cm2m,p25,p5
      parameter (cm2m=0.01, p5=0.5, p25=0.25)
c
      integer k
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Compute interface depth (or flat levels thickness) HC and the
c  average thickness of the hybrid levels HAVG
c-----------------------------------------------------------------------
c
      if((kc.lt.0).or.(kc.gt.km)) then
        write(stdout,10) kc
  10    format(/,' SETDEPTHS - illegal interface level, KC = ',i4)
        call exitus('SETDEPTHS')
      endif
      hc=0.0
      do 20 k=1,kc
        hc=hc+hz(k)
  20  continue
      havg=0.0
      do 30 k=kc+1,km
        havg=havg+hz(k)
  30  continue
      write(stdout,40)
  40  format(/' PE Model: ZPE (m), HZ (m)',/)
      do 60 k=1,km
        write(stdout,50) k,zpe(k)*cm2m,hz(k)*cm2m
  50    format(i4,4f11.5 )
  60  continue
c
c-----------------------------------------------------------------------
c  Set the depths of each tracer and velocity point.
c-----------------------------------------------------------------------
c
      call vertgrid
c
c-----------------------------------------------------------------------
c  Compare model levels to supplied data levels.
c-----------------------------------------------------------------------
c
      call check_depths
c
      return
      end
