       program test_solver
c
c=======================================================================
c                                                                    ===
c      This program solves an elliptic equation D.[HG(q)]=D.(r1,r2)  ===
c      with the information nece-in from ASCII files.                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <iounits.h>
#include <convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nval
      real    c0
      parameter (nval=20, c0=0.0)
c
      integer na,nabstl,nc,ncgst,nf,nfill,ni,nini,npc,npcg,nr,nrel
      integer cgstvc(nval),fillvc(nval),invc(nval),its(nval)
#ifdef sunfpe
      integer ieeer,my_handler,ieee_handler
#endif
#ifdef timesolver
      real    tim0
#endif
      real absvc(nval),pcgvc(nval),prand(np),pzero(np),rat(nval),
     &     relvc(nval)
#ifdef timesolver
     &     ,tim(nval)
#endif
      real         rand
      character*80  fmt1,fmt2,itfile,rsfile,tmfile
      character*120 fmt3
c
#ifdef sunfpe
      external my_handler
c
#endif
      data pzero /np*c0/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Set trap for floating point exceptions.
c-----------------------------------------------------------------------
c
      ieeer=ieee_handler('set','common',my_handler)
      if(ieeer.ne.0) print *,' IEEE_HANDLER cannot set my_handler'
c
#endif
c-----------------------------------------------------------------------
c  Read in the inputs for the run.
c-----------------------------------------------------------------------
c
      call tsslrd (nval,nabstl,absvc,ncgst,cgstvc,nfill,fillvc,nini,
     &             invc,npcg,pcgvc,nrel,relvc,itfile,rsfile,tmfile)
c
c-----------------------------------------------------------------------
c  Set-up random initial field.
c-----------------------------------------------------------------------
c
      do 10 na = 1, np
         prand(na) = rand(1)
  10  continue
c
c-----------------------------------------------------------------------
c  Set-up output files and variable formats.
c-----------------------------------------------------------------------
c
      open (unit=113, file=itfile, status='unknown')
      open (unit=117, file=rsfile, status='unknown')
#ifdef timesolver
      open (unit=119, file=tmfile, status='unknown')
#endif
c
      write (113,900) 'Number of iterations to converge:'
      write (117,900) 'Ratio of final residual to target residual:'
#ifdef timesolver
      write (119,900) 'Speed-up factor:'
#endif
c
      write (fmt1,810) npcg
      write (fmt2,820) npcg
      write (fmt3,830) npcg,npcg,npcg
c
c-----------------------------------------------------------------------
c  Loop over all test values, examining solver.
c-----------------------------------------------------------------------
c
      do 70 na = 1, nabstl
         tolabs = dble(absvc(na))
         write (113,910) tolabs
         write (117,910) tolabs
#ifdef timesolver
         write (119,910) tolabs
#endif
         do 60 nr = 1, nrel
            tolrel = dble(relvc(nr))
            write (113,920) tolrel
            write (117,920) tolrel
            write (119,920) tolrel
            do 50 ni = 1, nini
c
c  Set unpreconditioned stats.
c
               cgstat = 0
               if (invc(ni).eq.0) then
                  call tstsol (pzero)
                else
                  call tstsol (prand)
               end if
#ifdef timesolver
               tim0 = dttpcg(1) + dttpcg(2)
#endif
c
c  Continue with tests.
c
               if (invc(ni).eq.0) then
                  write (113,930) 'zero',mican
                  write (117,940) 'zero',residu/(tolrel*resini+tolabs)
#ifdef timesolver
                  write (119,950) 'zero',tim0
#endif
                else
                  write (113,930) 'random',mican
                  write (117,940) 'random',residu/(tolrel*resini+tolabs)
#ifdef timesolver
                  write (119,950) 'random',tim0
#endif
               end if
               do 40 nc = 1, ncgst
                  cgstat = cgstvc(nc)
                  write (113,960) cgstat
                  write (113,fmt3) char(92),(pcgvc(npc), npc=1,npcg)
                  write (117,960) cgstat
                  write (117,fmt3) char(92),(pcgvc(npc), npc=1,npcg)
#ifdef timesolver
                  write (119,960) cgstat
                  write (119,fmt3) char(92),(pcgvc(npc), npc=1,npcg)
#endif
                  do 30 nf = 1, nfill
                     fillin = fillvc(nf)
                     do 20 npc = 1, npcg
                        tolpcg = dble(pcgvc(npc))
                        if (invc(ni).eq.0) then
                           call tstsol (pzero)
                         else
                           call tstsol (prand)
                        end if
                        its(npc) = mican
                        rat(npc) = residu/(tolrel*resini+tolabs)
#ifdef timesolver
                        tim(npc) = tim0/(dttpcg(1)+dttpcg(2))
#endif
  20                 continue
                     write (113,fmt1) fillin,(its(npc), npc=1,npcg)
                     write (117,fmt2) fillin,(rat(npc), npc=1,npcg)
#ifdef timesolver
                     write (119,fmt2) fillin,(tim(npc), npc=1,npcg)
#endif
#ifdef sunflush
                     call flush(113)
                     call flush(117)
# ifdef timesolver
                     call flush(119)
# endif
#endif
  30              continue
  40           continue
  50        continue
  60     continue
  70  continue
c
c-----------------------------------------------------------------------
c  Clean up & exit
c-----------------------------------------------------------------------
c
      close (113)
      close (117)
#ifdef timesolver
      close (119)
#endif
c
      call exitus ('TEST_SOLVER DONE')
c
 810  format ('(i10,2h |,',i10,'(2x,i10))')
 820  format ('(i10,2h |,',i10,'(2x,1pg10.3))')
 830  format ('(11(1h-),1h+,',i10,'(12(1h-))/',
     &        '5hfill ,a1,6h tol |,',i10,'(2x,1pg10.3)/',
     &        '11(1h-),1h+,',i10,'(12(1h-)))')
 900  format (/a)
 910  format (/30('='),' tolabs = ',1pg9.2,1x,30('='))
 920  format (/30('+'),' tolrel = ',1pg9.2,1x,30('+'))
 930  format (/20('-'),1x,a,' initialization ',20('-')//
     &        'Unpreconditioned iteration count:  ',i10)
 940  format (/20('-'),1x,a,' initialization ',20('-')//
     &        'Unpreconditioned residual ratio:  ',1pg10.3)
#ifdef timesolver
 950  format (/20('-'),1x,a,' initialization ',20('-')//
     &        'Unpreconditioned time:  ',1pg10.3,'  (s)')
#endif
 960  format (/'cgstat = ',i2/'Fill-in Bandwith versus Small Value',
     &        ' Tolerance')
c
      end
