      subroutine ts2poteng
c
c=======================================================================
c                                                                    ===
c  Computes pot. energgy from t,s at z-levels                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <meants.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nzp1
      real c0,c1,grav,m2cm,p5,spval

      parameter(c0=0.0, grav=980.6, m2cm=100.0, p5=0.5, spval=1.0e30)
      parameter(c1=1.0, nzp1=nz+1)
c
      integer ip,k,kstop
      real    dum,scle,sig0,sig1
      real azm(mprof),pe(0:nzp1),sigavg(nz),sigm(mprof),wk(mprof),
     &     zpe(0:nzp1)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Construct horizontally averaged sigma.
c-----------------------------------------------------------------------
c
c  Compute density on average profile levels.
c
      do 10 k = 1, nprof
         azm(k) = abs(zm(k))*m2cm
         call state_ini(tm(k),sm(k),azm(k),sigm(k))
  10  continue
c
c  Interpolate to data levels.
c
      if (intopt.eq.1) then
         call spline (azm,sigm,nprof,spval,spval,wk)
         do 20 k = 1, kfld
            call splint (azm,sigm,wk,nprof,zfld(k),sigavg(k),dum)
  20     continue
       else
         do 30 k = 1, kfld
            call lintrp (nprof,azm,sigm,1,zfld(k),sigavg(k))
  30     continue
      end if
c
c-----------------------------------------------------------------------
c  Compute potential energy with respect to mean sea level.
c-----------------------------------------------------------------------
c
      scle = p5*grav
c
      do 60 ip = 1, im*jm
c
c  Compute potential energy as a function of depth.
c
         pe(0)  = c0
         zpe(0) = c0
         call state_ini(t(ip,1,1),t(ip,1,2),zfld(1),sig1)
         sig1   = sig1 - sigavg(1)
         pe(1)  = grav*sig1*zfld(1)
         zpe(1) = zfld(1)
c
         kstop = 0
         k     = 2
         do 40 while ((kstop.eq.0).and.(k.le.kfld))
            sig0 = sig1
            call state_ini(t(ip,k,1),t(ip,k,2),zfld(k),sig1)
            sig1   = sig1 - sigavg(k)
            zpe(k) = zfld(k)
            pe(k)  = pe(k-1) + scle*(sig0+sig1)*(zpe(k)-zpe(k-1))
            if (zfld(k).ge.h(ip)) kstop = k
            k = k + 1
  40     continue
c
         if (kstop.ne.0) then
            dum = (zpe(kstop)-h(ip)) / (zpe(kstop)-zpe(kstop-1))
            sig1 = dum*sig0 + (c1-dum)*sig1
            pe(kstop) = pe(kstop-1) + scle*(sig0+sig1)*
     &                                              (h(ip)-zpe(kstop-1))
          else
            kstop = kfld + 1
            pe(kstop) = pe(kstop-1) + grav*sig1*(h(ip)-zpe(kstop-1))
         end if
         zpe(kstop) = h(ip)
c
c  Compute depth averaged potential energy.
c
         poteng(ip) = c0
c
         do 50 k = 1, kstop
            poteng(ip) =poteng(ip) +p5*(pe(k)+pe(k-1))*(zpe(k)-zpe(k-1))
  50     continue
c
         poteng(ip) = poteng(ip) / h(ip)
  60  continue
c
      return
      end
