      subroutine tsslrd (nval,nabstl,absvc,ncgst,cgstvc,nfill,fillvc,
     &                   nini,invc,npcg,pcgvc,nrel,relvc,itfile,rsfile,
     &                   tmfile)
c
c=======================================================================
c                                                                    ===
c  This routine reads the parameters to be tested in the elliptic    ===
c  solvers.                                                          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NVAL     Maximum number of test values.        (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NABSTL   Number of absolute tolerances.        (integer)       ===
c     ABSVC    Absolute tolerances.                  (real vector)   ===
c     NCGST    Number of statuses.                   (integer)       ===
c     CGSTVC   Statuses of SPARSKIT CG solver.       (integer vector)===
c     NFILL    Number of fill-in terms.              (integer)       ===
c     FILLVC   Bandwidth for fill-in.                (integer vector)===
c     NINI     Number of different initial guesses.  (integer)       ===
c     INVC     Initial guess flags.                  (integer vector)===
c     NPCG     Number of small term tolerances.      (integer)       ===
c     PCGVC    Tolerance for retaining small terms.  (real vector)   ===
c     NREL     Number of relative tolerances.        (integer)       ===
c     RELVC    Relative tolerances.                  (real vector)   ===
c     ITFILE   Name for output table of iterations.  (string)        ===
c     RSFILE   Name for output table of residuals.   (string)        ===
c     TMFILE   Name for output timing table.         (string)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer card,ios,n,nabstl,ncgst,nfill,nini,npcg,nrel,nval
      integer cgstvc(nval),fillvc(nval),invc(nval)
      real         absvc(nval),pcgvc(nval),relvc(nval)
      character*80 itfile,rsfile,tmfile
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read while no errors and not end-of-input card.
c-----------------------------------------------------------------------
c
      read (5,*,iostat=ios) card
c
      do 10 while ( (card.gt.0) .and. (ios.eq.0) )
c
         if (card.eq.1) then
            read (5,*) nabstl,(absvc(n), n=1,nabstl)
          elseif (card.eq.2) then
            read (5,*) nrel,(relvc(n), n=1,nrel)
          elseif (card.eq.3) then
            read (5,*) nini,(invc(n), n=1,nini)
          elseif (card.eq.4) then
            read (5,*) ncgst,(cgstvc(n), n=1,ncgst)
          elseif (card.eq.5) then
            read (5,*) nfill,(fillvc(n), n=1,nfill)
          elseif (card.eq.6) then
            read (5,*) npcg,(pcgvc(n), n=1,npcg)
          elseif (card.eq.7) then
            read (5,'(a)') itfile
          elseif (card.eq.8) then
            read (5,'(a)') rsfile
          elseif (card.eq.9) then
            read (5,'(a)') tmfile
         end if
c
         if (ios.eq.0) read (5,*,iostat=ios) card
c
  10  continue
c
      return
      end
