      subroutine tstsol (pinit)
c
c=======================================================================
c                                                                    ===
c  This routine solves an elliptic equation D.[HG(q)]=D.(r1,r2)      ===
c  with the information nece-in from ASCII files.                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <iounits.h>
#include <convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer coord,i,im,ip,ip1,j,jm,km,lsegz
      integer landt(np)
#ifdef coast
      integer iep(isesize),ieq(isesize),iez(isesize),isp(isesize),
     *        isq(isesize),isz(isesize)
#endif
#ifndef solvercg
      integer ia(np+1),ir(np),ja(9*np)
#endif
c
      real c0,c1,c6,deg2cm,dx,dxx,dy,dyy
      real a(np*9),hv(np),hvex(np),pbar(np),pbaroE(ijmx),pbaroN(ijmx),
     &     pbaroS(ijmx),pbaroW(ijmx),pinit(np),
     &     pwork(np),vmetx(np),vmety(np),ztd(np)
#ifdef strmtst
     &     ,corfac(np)
#endif
#ifdef coast
      real fkmp(np),fkmq(np),fkmz(np)
#endif
#ifndef solvercg
      real am(9*np),pspar(np),rp(np)
#else
      double precision wk(np,4)
#endif
#ifdef testinversion
      real xtest(np)
#endif
c
      parameter(c0=0.0,c1=1.0,c6=6.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Rewind ugly transfer files
c-----------------------------------------------------------------------
c
      rewind (tst2out)
      rewind (tst3out)
      rewind (tst4out)
      rewind (tst5out)
      rewind (tst6out)
      rewind (tst7out)
      rewind (tst8out)
c
c-----------------------------------------------------------------------
c  First read-in the vital parameters:
c-----------------------------------------------------------------------
c
c  Read in array sizes and other scalar data.
c
      read(tst2out) im,jm,km,lsegz,dx,dy,coord,deg2cm
c
c  Check that the work arrays are sufficiently large.
c
      if ((im+2)*(jm+2) .gt. np)
     &    print *,'Reset NP to at least ', (im+2)*(jm+2)
c
      if (lsegz*jm .gt. isesize)
     &    print *,'Reset ISESIZE to at least ', lsegz*jm
c
      if (max(im,jm) .gt. ijmx)
     &    print *,'Reset IJMX to at least ', max(im,jm)
c
      if ( ((im+2)*(jm+2).gt.np) .or. (lsegz*jm.gt.isesize) .or.
     &      (max(im,jm) .gt. ijmx) ) call exitus ('TEST_SOLVER')
c
c  Read in domain and field array data.
c
#ifndef strmtst
      call read_inputs (im,jm,landt,hv,vmetx,vmety,
#else
      call read_inputs (im,jm,landt,hv,vmetx,vmety,corfac,
#endif
     &                  pbaroS,pbaroN,pbaroW,pbaroE,ztd)
c
      do 10 i=1,im
        do 10 j=1,jm
           ip=i+(j-1)*im
           hvex(ip)=hv(ip)
  10  continue
c
c     Get the masking indices
c     -----------------------
#ifdef coast
      call mskind (im,jm,km,lsegz,landt,isz,iez,isq,ieq,isp,iep,hvex,
     *             fkmz,fkmp,fkmq)
#endif
c
c-----------------------------------------------------------------------
c  Adjust dx,dy according to coordinate system for Matrix construction.
c-----------------------------------------------------------------------
c
      if (coord.eq.0)then
         dxx=dx
         dyy=dy
      else
         dxx=dx*deg2cm
         dyy=dy*deg2cm
      endif
#ifndef strmtst
      do 20 ip=1,jm*im
         vmetx(ip)=vmetx(ip)/vmety(ip)
  20  continue
#endif
c
      do 40 j=1,jm
         do 30 i=1,im
            ip=i+(j-1)*im
            pwork(ip)=pinit(ip)
  30     continue
  40  continue
c
c-----------------------------------------------------------------------
c  Get boundary conditions and fill-in the working array.
c-----------------------------------------------------------------------
c
c  Update the time change  at the southern and  northern boundaries.
c
      do 50 i=1,im
         pwork(i)=pbaroS(i)
         ip=i+(jm-1)*im
         pwork(ip)=pbaroN(i)
  50  continue
c
#ifdef cyclic
c
c  Set Cyclic boundary conditions.
c
      do 60 j=1,jm
         ip=(j-1)*im+1
         ip1=(j-1)*im+im-1
         pwork(ip)=pwork(ip1)
         ip=(j-1)*im+im
         ip1=(j-1)*im+2
         pwork(ip)=pwork(ip1)
  60  continue
#else
c
c  Update the time change of stream function at the western and
c  eastern boundaries.
c
      do 70 j=1,jm
         ip=1+(j-1)*im
         pwork(ip)=pbaroW(j)
         ip1=im+(j-1)*im
         pwork(ip1)=pbaroE(j)
  70  continue
#endif
c
c-----------------------------------------------------------------------
c  Solve the Elliptic equation for the variable pbar.
c-----------------------------------------------------------------------
c
#ifndef strmtst
# ifdef coast
      call Press_solve (im,jm,lsegz,dxx,dyy,
     *                  isq,ieq,isp,iep,a,pwork,hvex,ztd,vmetx,
# else
      call Press_solve (im,jm,dxx,dyy,a,pwork,hvex,ztd,vmetx,
# endif
# ifndef solvercg
     *                  ir,ia,ja,am,rp,pspar
# else
     *                  wk,np
# endif
# ifdef testinversion
     *                 ,xtest
# endif
     *                     )
#else
# ifdef coast
      call Stream_solve(im,jm,lsegz,dxx,dyy,
     *                     isq,ieq,isz,iez,a,pwork,hvex,ztd,
# else
      call Stream_solve(im,jm,dxx,dyy,
     *                     a,pwork,hvex,ztd,
# endif
     *                     vmetx,vmety,corfac,
     *                     ir,ia,ja,am,rp,pspar
     *                     )
#endif
c
      do 80 ip=1,jm*im
         pbar(ip)=pwork(ip)
  80  continue
c
#ifdef rmpressmean
c-----------------------------------------------------------------------
c  Remove a mean from pbar if desired.
c-----------------------------------------------------------------------
c
# ifdef coast
      call rmmean_pbar (im,jm,lsegz,pbar,isp,iep)
# else
      call rmmean_pbar (im,jm,pbar)
# endif
c
#endif
c-----------------------------------------------------------------------
c  Write the pbar field into a file as output.
c-----------------------------------------------------------------------
c
      open (unit=tst9out,file='pbar_out_driver.dat',status='unknown')
      do 100 j=1,jm
         do 90 i=1,im
           ip=i+(j-1)*im
           write(tst9out,'(1pe17.8)') pbar(ip)         
  90     continue
 100  continue
      close (tst9out)
c
      return
      end
