      subroutine wrtbgrd (grdid,grdnm,im,jm,km,lon,lat,di,dj)
c
c=======================================================================
c                                                                    ===
c  This routine writes the indicated boundary grid.                  ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  DI......X-offset from edge.         (integer)                     ===
c  DJ......Y-offset from edge.         (integer)                     ===
c  GRDID...Boundary grid identifier.   (integer)                     ===
c  GRDNM...Boundary grid name.         (character)                   ===
c  IM......Number of x-grid points.    (integer)                     ===
c  JM......Number of y-grid points.    (integer)                     ===
c  KM......Number of z-grid points.    (integer)                     ===
c  LAT.....Latitudes.                  (real array)                  ===
c  LON.....Longitudes.                 (real array)                  ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT    standard output unit.        (integer)               ===
c                                                                    ===
c  /PI_NETCFD/                                                       ===
c                                                                    ===
c     NCOUTID   NetCDF ID for output file.   (integer)               ===
c                                                                    ===
c         Calls:  EXITUS                                             ===
c  netcdf Calls:  NCVPT                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <netcdf.inc>
#include <pi_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer di,dj,grdid,i,im,j,jm,k,km
      integer count(4),start(4)
      real          blat(mx),blon(mx),lat(im,jm),lon(im,jm)
      character*(*) grdnm
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write southern boundary.
c-----------------------------------------------------------------------
c
      if (km.eq.1) then
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=im-2*di
        start(3)=south
        count(3)=1
        call ncvpt(ncoutid,grdid,start,count,lon(di+1,dj+1),rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'x-axis',south
          call exitus('WRTBGRD')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,grdid,start,count,lat(di+1,dj+1),rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'y-axis',south
          call exitus('WRTBGRD')
        endif
       else
        count(1)=1
        count(2)=1
        start(3)=1
        count(3)=im-2*di
        start(4)=south
        count(4)=1
        do 10 k = 1, km
          start(1)=xindx
          start(2)=k
          call ncvpt(ncoutid,grdid,start,count,lon(di+1,dj+1),rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'x-axis',k,south
            call exitus('WRTBGRD')
          endif
          start(1)=yindx
          call ncvpt(ncoutid,grdid,start,count,lat(di+1,dj+1),rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'y-axis',k,south
            call exitus('WRTBGRD')
          endif
  10    continue
      end if
c
c-----------------------------------------------------------------------
c  Write northern boundary.
c-----------------------------------------------------------------------
c
      if ((grdnm(1:1).ne.'v').and.(grdnm(1:1).ne.'V')) then
        j = jm
       else
        j = jm - 1
      end if
c
      if (km.eq.1) then
        start(1)=xindx
        count(1)=1
        start(3)=north
        count(3)=1
        call ncvpt(ncoutid,grdid,start,count,lon(di+1,j-dj),rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'x-axis',north
          call exitus('WRTBGRD')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,grdid,start,count,lat(di+1,j-dj),rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'y-axis',north
          call exitus('WRTBGRD')
        endif
       else
        count(1)=1
        start(4)=north
        count(4)=1
        do 20 k = 1, km
          start(1)=xindx
          start(2)=k
          call ncvpt(ncoutid,grdid,start,count,lon(di+1,j-dj),rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'x-axis',k,north
            call exitus('WRTBGRD')
          endif
          start(1)=yindx
          call ncvpt(ncoutid,grdid,start,count,lat(di+1,j-dj),rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'y-axis',k,north
            call exitus('WRTBGRD')
          endif
  20    continue
      end if
c
c-----------------------------------------------------------------------
c  Write western boundary.
c-----------------------------------------------------------------------
c
      do 30 j=dj+1,jm-dj
        blon(j-dj)=lon(di+1,j)
        blat(j-dj)=lat(di+1,j)
  30  continue
c
      if (km.eq.1) then
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=jm-2*dj
        start(3)=west
        count(3)=1
        call ncvpt(ncoutid,grdid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'x-axis',west
          call exitus('WRTBGRD')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,grdid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'y-axis',west
          call exitus('WRTBGRD')
        endif
       else
        count(1)=1
        start(3)=1
        count(3)=jm-2*dj
        start(4)=west
        count(4)=1
        do 40 k = 1, km
          start(1)=xindx
          start(2)=k
          call ncvpt(ncoutid,grdid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'x-axis',k,west
            call exitus('WRTBGRD')
          endif
          start(1)=yindx
          call ncvpt(ncoutid,grdid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,910) grdnm,'y-axis',k,west
            call exitus('WRTBGRD')
          endif
  40    continue
      end if
c
c-----------------------------------------------------------------------
c  Write eastern boundary.
c-----------------------------------------------------------------------
c
      if ((grdnm(1:1).ne.'v').and.(grdnm(1:1).ne.'V')) then
        i = im
       else
        i = im - 1
      end if
c
      do 50 j=dj+1,jm-dj
        blon(j-dj)=lon(i-di,j)
        blat(j-dj)=lat(i-di,j)
  50  continue
c
      if (km.eq.1) then
        start(1)=xindx
        count(1)=1
        start(3)=east
        count(3)=1
        call ncvpt(ncoutid,grdid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'x-axis',east
          call exitus('WRTBGRD')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,grdid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,900) grdnm,'y-axis',east
          call exitus('WRTBGRD')
        endif
       else
        count(1)=1
        start(4)=east
        count(4)=1
        do 60 k = 1, km
          start(1)=xindx
          start(2)=k
          call ncvpt(ncoutid,grdid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,900) grdnm,'x-axis',east
            call exitus('WRTBGRD')
          endif
          start(1)=yindx
          call ncvpt(ncoutid,grdid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,900) grdnm,'y-axis',east
            call exitus('WRTBGRD')
          endif
  60    continue
      end if
c
      return
c
 900  format(/' WRTBGRD - error while writing variable: ',a,1x,a,
     *        ' at BOUNDARY = ',i1)
 910  format(/' WRTBGRD - error while writing variable: ',a,1x,a,
     *        ' at LEVEL = ',i5,2x,' and BOUNDARY = ',i1)
c
      end
