#ifdef coast
      subroutine Ellip_sol (im,jm,lseg,pwork,a,ztd,ien,isn,
#else
      subroutine Ellip_sol (im,jm,pwork,a,ztd,
#endif
     *                      pcg,rcg,ucg,puse,iou)
c
c=======================================================================
c                                                                    ===
c  This is the subroutine that solves the Elliptic equation for the  ===
c  time change in the surface pressure  and it has a Conjugate       ===
c  gradient solver.                                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ibeg,ifin,im,iou,j,jbeg,jfin,jm,npts
#ifdef coast
      integer iend,istr,l,lseg
      integer ien(jm,lseg),isn(jm,lseg)
#endif
      FLOAT
     &                 a(im,jm,0:8),pwork(im,jm),ztd(im,jm)
      double precision alpha,alphad,alphan,beta,betan,c0,q0,q1,q2,q3,q4,
     &                 q5,q6,q7,q8,res,resid,reszero,sumcorr
#ifdef checkinversion
     &                 ,sumresid
#endif
      double precision pcg(im,jm),puse(im,jm),rcg(im,jm),ucg(im,jm)
c
      parameter(c0=0.d0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initialize the work area
c-----------------------------------------------------------------------
c
      do 20 i=1,im
        do 10 j=1,jm
          pcg(i,j)=c0
          puse(i,j)=dble(pwork(i,j))
  10    continue
  20  continue
c
      do 40 i=1,im
        do 30 j=1,jm
          rcg(i,j)=c0
          ucg(i,j)=c0
  30    continue
  40  continue
c
      mican=0
c
      ibeg=2
      ifin=im-1
      jbeg=2
      jfin=jm-1
c
c
c     Initialization for conjugate gradients:
c     ---------------------------------------
      do 70 j=jbeg,jfin
#ifdef coast
       do 60 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 70
        iend=ien(j,l)
        do 50 i=istr,iend
#else
        do 50 i=ibeg,ifin
#endif
#ifndef cyclic
          q0=puse(i,j)
          q1=puse(i,j+1)
          q2=puse(i,j-1)
          q3=puse(i-1,j)
          q4=puse(i+1,j)
          q5=puse(i-1,j+1)
          q6=puse(i+1,j+1)
          q7=puse(i+1,j-1)
          q8=puse(i-1,j-1)
#else
          q0=puse(i,j)
          q1=puse(i,j+1)
          q2=puse(i,j-1)
          if(i.eq.2) then
             q3=puse(im-1,j)
             q5=puse(im-1,j+1)
             q8=puse(im-1,j-1)
          else
             q3=puse(i-1,j)
             q5=puse(i-1,j+1)
             q8=puse(i-1,j-1)
          endif
          if(i.eq.im-1)then
             q4=puse(2,j)
             q6=puse(2,j+1)
             q7=puse(2,j-1)
          else
             q4=puse(i+1,j)
             q6=puse(i+1,j+1)
             q7=puse(i+1,j-1)
          endif
#endif
          resid=dble(a(i,j,0))*q0+dble(a(i,j,1))*q1
     *         +dble(a(i,j,2))*q2+dble(a(i,j,3))*q3
     *         +dble(a(i,j,4))*q4+dble(a(i,j,5))*q5
     *         +dble(a(i,j,6))*q6+dble(a(i,j,7))*q7
     *         +dble(a(i,j,8))*q8
          resid=dble(ztd(i,j))-resid
          pcg(i,j)=resid
          rcg(i,j)=resid
  50    continue
  60   continue
  70  continue
c
      restarget=real(c0)
c
c-----------------------------------------------------------------------
c  Main loop.
c-----------------------------------------------------------------------
c
  80  continue
c
      mican=mican+1
      if(mican.gt.maxits) then
         residu=real(res)
         mican=maxits
         do 100 i=1,im
           do 90 j=1,jm
             pwork(i,j)=real(puse(i,j))
  90       continue
 100     continue
         return
      endif
c
c     Conjugate Gradient method:
c     -------------------------
      do 130 j=jbeg,jfin
#ifdef coast
       do 120 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 130
        iend=ien(j,l)
        do 110 i=istr,iend
#else
        do 110 i=ibeg,ifin
#endif
#ifndef cyclic
          q0=pcg(i,j)
          q1=pcg(i,j+1)
          q2=pcg(i,j-1)
          q3=pcg(i-1,j)
          q4=pcg(i+1,j)
          q5=pcg(i-1,j+1)
          q6=pcg(i+1,j+1)
          q7=pcg(i+1,j-1)
          q8=pcg(i-1,j-1)
#else
          q0=pcg(i,j)
          q1=pcg(i,j+1)
          q2=pcg(i,j-1)
          if(i.eq.2) then
             q3=pcg(im-1,j)
             q5=pcg(im-1,j+1)
             q8=pcg(im-1,j-1)
          else
             q3=pcg(i-1,j)
             q5=pcg(i-1,j+1)
             q8=pcg(i-1,j-1)
          endif
          if(i.eq.im-1)then
             q4=pcg(2,j)
             q6=pcg(2,j+1)
             q7=pcg(2,j-1)
          else
             q4=pcg(i+1,j)
             q6=pcg(i+1,j+1)
             q7=pcg(i+1,j-1)
          endif
#endif
          ucg(i,j)=dble(a(i,j,0))*q0+dble(a(i,j,1))*q1
     *            +dble(a(i,j,2))*q2+dble(a(i,j,3))*q3
     *            +dble(a(i,j,4))*q4+dble(a(i,j,5))*q5
     *            +dble(a(i,j,6))*q6+dble(a(i,j,7))*q7
     *            +dble(a(i,j,8))*q8
 110    continue
 120   continue
 130  continue
c
      alphan=c0
      alphad=c0
c
      do 160 j=jbeg,jfin
#ifdef coast
       do 150 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 160
        iend=ien(j,l)
        do 140 i=istr,iend
#else
        do 140 i=ibeg,ifin
#endif
          alphan=alphan+rcg(i,j)*rcg(i,j)
          alphad=alphad+pcg(i,j)*ucg(i,j)
 140    continue
 150   continue
 160  continue
c
      alpha=alphan/alphad
c
      do 190 j=jbeg,jfin
#ifdef coast
       do 180 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 190
        iend=ien(j,l)
        do 170 i=istr,iend
#else
        do 170 i=ibeg,ifin
#endif
          puse(i,j)=puse(i,j)+alpha*pcg(i,j)
          rcg(i,j)=rcg(i,j)-alpha*ucg(i,j)
 170    continue
 180   continue
 190  continue
c
      betan=c0
      do 220 j=jbeg,jfin
#ifdef coast
       do 210 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 220
        iend=ien(j,l)
        do 200 i=istr,iend
#else
        do 200 i=ibeg,ifin
#endif
          betan=betan+rcg(i,j)*rcg(i,j)
 200    continue
 210   continue
 220  continue
c
      beta=betan/alphan
c
      do 250 j=jbeg,jfin
#ifdef coast
       do 240 l=1,lseg
        istr=isn(j,l)
        if(istr.eq.0) go to 250
        iend=ien(j,l)
        do 230 i=istr,iend
#else
        do 230 i=ibeg,ifin
#endif
          pcg(i,j)=rcg(i,j)+beta*pcg(i,j)
 230    continue
 240   continue
 250  continue 
c
c     Calculate ||residuals|| (2-norm) and check convergence:
c     -------------------------------------------------------    
c
      sumcorr=c0
      npts=0
      do 280 j=jbeg,jfin
#ifdef coast
        do 270 l=1,lseg
          istr=isn(j,l)
          if(istr.eq.0) go to 280
          iend=ien(j,l)
          do 260 i=istr,iend
#else
          do 260 i=ibeg,ifin
#endif
            npts=npts+1
            sumcorr=sumcorr+rcg(i,j)*rcg(i,j)
 260      continue
 270    continue
 280  continue
c
      res=dsqrt(sumcorr/dble(npts))
      if(mican.eq.1) then
        resini=real(res)
        reszero=res
        restarget=resini*tolrel+tolabs
      endif
c
c     This convergence criterion is consistent with SPARSKIT
c     ------------------------------------------------------
c
      if(res.lt.(dble(tolrel)*reszero+dble(tolabs))) then
        residu=real(res)
        do 300 i=1,im
          do 290 j=1,jm
            pwork(i,j)=real(puse(i,j))
 290      continue
 300    continue
        return
      else
c
#ifdef checkinversion
c
c       Check the actual residual ||Ax-b||:
c       -----------------------------------
c
        sumresid=-100000.0
        do 330 j=jbeg,jfin
# ifdef coast
         do 320 l=1,lseg
          istr=isn(j,l)
          if(istr.eq.0) go to 330
          iend=ien(j,l)
          do 310 i=istr,iend
# else
          do 310 i=ibeg,ifin
# endif
            q0=puse(i,j)
            q1=puse(i,j+1)
            q2=puse(i,j-1)
            q3=puse(i-1,j)
            q4=puse(i+1,j)
            q5=puse(i-1,j+1)
            q6=puse(i+1,j+1)
            q7=puse(i+1,j-1)
            q8=puse(i-1,j-1)
            resid=dble(a(i,j,0))*q0+dble(a(i,j,1))*q1
     *           +dble(a(i,j,2))*q2+dble(a(i,j,3))*q3
     *           +dble(a(i,j,4))*q4+dble(a(i,j,5))*q5
     *           +dble(a(i,j,6))*q6+dble(a(i,j,7))*q7
     *           +dble(a(i,j,8))*q8
            resid=dble(ztd(i,j))-resid
            sumresid=max(sumresid,dabs(resid))
 310      continue
 320     continue
 330    continue
        write (99, *) mican,res,sumresid
c
#endif
c
        go to 80
c           
      endif 
c
      end
