#ifdef coast
       subroutine Press_solve(im,jm,lseg,dx,dy,
     *                     isq,ieq,isp,iep,a,pwork,hvex,ztd,vmetx,
#else
       subroutine Press_solve(im,jm,dx,dy,a,pwork,hvex,ztd,vmetx,
#endif
#ifdef freesurf
     *                     diagcof,
#endif
#ifndef solvercg
     *                     ir,ia,ja,am,rp,pspar
#else
     *                     wk,np
#endif
#if defined testinversion | defined localfilter
     *                     ,xtest
#endif
     *                     )
c
c=======================================================================
c                                                                    ===
c        This subroutine assembles the matrix for the elliptic       ===
c        equation describing the surface pressure and calls          ===
c        cg solvers.                                                 ===
c                                                                    ===
#ifndef solvercg
c        CALLS: SPARS_SOLVE                                          ===
#else
c        CALLS: ELLIP_SOL                                            ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#if defined testsolver | defined solvercg | defined lapfilter | defined localfilter
# include <iounits.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iend,im,istr,j,jend,jm,jstr,k,numcell
#ifndef solvercg
      integer irow,jcol,kk,krow,nnz
      integer ir(im,jm),ia(im*jm+1),ja(9*im*jm),ik(0:8),jkk(0:8)
#else
      integer iou,np
#endif
#if defined checkinversion | !defined solvercg
      integer nnn
#endif
#ifdef coast
      integer l,lseg
      integer isp(jm,lseg),iep(jm,lseg),isq(jm,lseg),ieq(jm,lseg)
#endif
#ifdef testinversion
      logical first
#endif
c
      FLOAT
     &      avg_qty,avg_vol,c0,c1,c2,c4,cof0,cof1,cof2,cof3,cof4,cof5,
     &    cof6,cof7,cof8,delxt,delxua,delxub,delxuc,delxud,delyt,delyua,
     &     delyub,delyuc,delyud,dx,dxt,dxuex,dy,dyt,dyuex,hxa,hxb,hxc,
     &     hxd,hya,hyb,hyc,hyd,p5,p25,sumvol,volmean
#if defined checkinversion
     &     ,resv,resreal
#endif
#if defined checkinversion | defined testinversion | defined localfilter
     &     ,z0,z1,z2,z3,z4,z5,z6,z7,z8
#endif
#ifdef freesurf
     &     ,diagcof
#endif
#if defined  lapfilter
     &     ,crossfac,epsi,faceps
#elif defined localfilter
     &     ,a1,a2,b1,b2,resv1,resv2,thetacof
#endif
#ifndef solvercg
     &     ,zztd
#endif
#ifdef testinversion
     &     ,rand,sumxx,xdiff,zpi
#endif
      FLOAT
     &     a(im,jm,0:8),hvex(im,jm),pwork(im,jm),vmetx(im,jm),ztd(im,jm)
#if defined checkinversion
     &     ,resvv(200,200)
#endif
#if defined testinversion | defined localfilter
     &     ,xtest(im,jm)
#endif
#ifndef solvercg
     &     ,am(9*im*jm),pspar(im*jm),rp(im*jm)
#else
      double precision wk(np,4)
#endif
c
      parameter(c0=0.0,c1=1.0,c2=2.0,c4=4.0,p5=0.5,p25=0.25)
#if defined  lapfilter
      parameter(epsi=1.0e-6,crossfac=0.5)
#elif defined localfilter
      parameter(thetacof=0.05)
      parameter(a1= 3.2089344e-01 , a2= -3.9884308e-01,
     *          b1= 3.4825889e-01 , b2=  2.2617526e-01)
#endif
#ifdef testinversion
c
      save    first,zpi
      data first/.true./
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef testinversion
c-----------------------------------------------------------------------
c  Initialize the useful constants
c-----------------------------------------------------------------------
c
      if (first) then
         zpi = 4.0*atan(1.0)
         first = .false.
      end if
c
#endif
c-----------------------------------------------------------------------
c  Initialize the work area
c-----------------------------------------------------------------------
c
      do 10 i=1,im
      do 10 j=1,jm
#ifndef solvercg
         ir(i,j)=0
#endif
#ifdef checkinversion
         resvv(i,j)=c0
#endif
         do 10 k=0,8
            a(i,j,k)=c0
 10   continue
c
#ifndef solvercg
      ik(0)=0
      ik(1)=0
      ik(2)=0
      ik(3)=-1
      ik(4)=1
      ik(5)=-1
      ik(6)=1
      ik(7)=1
      ik(8)=-1
c
      jkk(0)=0
      jkk(1)=1
      jkk(2)=-1
      jkk(3)=0
      jkk(4)=0
      jkk(5)=1
      jkk(6)=1
      jkk(7)=-1
      jkk(8)=-1
#endif
c
      dxt=dx
      dyt=dy
      dxuex=dx
      dyuex=dy
c
c     Estimate a mean area of grid cells to normalize point equations
c     ---------------------------------------------------------------
      sumvol=c0
      numcell=0
#ifndef coast
      istr=1
      iend=im-1
#endif
c
      do 40 j=1,jm-1
#ifdef coast
         do 30 l=1,lseg
            istr=isq(j,l)
            if(istr.eq.0) go to 40
            iend=ieq(j,l)
#endif
            do 20 i=istr,iend
               numcell=numcell+1
               avg_qty=
     *              hvex(i,j)/vmetx(i,j)+hvex(i,j)*vmetx(i,j)
               avg_vol=p5*dxuex*dyuex/avg_qty
               sumvol=sumvol+avg_vol
 20         continue
 30      continue
 40   continue
      volmean=sumvol/FLoaT(numcell)
c
c-----------------------------------------------------------------------
c  Get the RHS (divergence form) for the equation.
c-----------------------------------------------------------------------
c
      istr=2
      iend=im-1
      jstr=2
      jend=jm-1
c
#ifdef testinversion
c-----------------------------------------------------------------------
c  Check whether driver is working properly.
c-----------------------------------------------------------------------
c
      open(unit=tst9out,file='pbar_out_exact.dat',status='new')
c
      do 60 j=1,jm
        do 50 i=1,im
          xtest(i,j)=sin(zpi*FLoaT(i)/FLoaT(im))
     *              *sin(zpi*FLoaT(j)/FLoaT(jm))
          write(tst9out,'(1pe17.8)') xtest(i,j)
          pwork(i,j)=xtest(i,j)
  50    continue
  60  continue
c
      close(tst9out)
c
      do 90 j=jstr,jend
# ifdef coast
         do 80 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 90
            iend=iep(j,l)
# endif
            do 70 i=istr,iend
              pwork(i,j)=rand(1)
  70        continue
  80      continue
  90  continue
c
#endif
c-----------------------------------------------------------------------
c  Generate arrays of coefficients for relaxation.
c  The local notation for the laplacian stencil is:
c
c                  |   |   |
c               ---5---1---6---
c                  |   |   |
c               ---3---0---4---
c                  |   |   |
c               ---8---2---7---
c                  |   |   |
c-----------------------------------------------------------------------
c
#ifndef solvercg
      nnn=0
#endif
c
      do 120 j=jstr,jend
#ifdef coast
         do 110 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 120
            iend=iep(j,l)
#endif
            do 100 i=istr,iend
c
#ifndef solvercg
               nnn=nnn+1
               ir(i,j)=nnn
#endif
               hxa=hvex(i-1,j-1)/vmetx(i-1,j-1)
               hxb=hvex(i,j-1)/vmetx(i,j-1)
               hxc=hvex(i,j)/vmetx(i,j)
               hxd=hvex(i-1,j)/vmetx(i-1,j)
c
               hya=hvex(i-1,j-1)*vmetx(i-1,j-1)
               hyb=hvex(i,j-1)*vmetx(i,j-1)
               hyc=hvex(i,j)*vmetx(i,j)
               hyd=hvex(i-1,j)*vmetx(i-1,j)
c     
               delxua=dxuex
               delxub=dxuex
               delxuc=dxuex
               delxud=dxuex
c
               delyua=dyuex
               delyub=dyuex
               delyuc=dyuex
               delyud=dyuex
c
               delxt=dxt
               delyt=dyt
c
               cof1=-(hxc/delxuc+hxd/delxud)/(c4*delxt)
     *              +(hyc/delyuc+hyd/delyud)/(c4*delyt)
c
               cof2=-(hxa/delxua+hxb/delxub)/(c4*delxt)
     *              +(hya/delyua+hyb/delyub)/(c4*delyt)
c
               cof3=+(hxa/delxua+hxd/delxud)/(c4*delxt)
     *              -(hya/delyua+hyd/delyud)/(c4*delyt)
c
               cof4=+(hxc/delxuc+hxb/delxub)/(c4*delxt)
     *              -(hyc/delyuc+hyb/delyub)/(c4*delyt)
c
               cof5=hxd/(c4*delxud*delxt)+hyd/(c4*delyud*delyt)
c     
               cof6=hxc/(c4*delxuc*delxt)+hyc/(c4*delyuc*delyt)
c     
               cof7=hxb/(c4*delxub*delxt)+hyb/(c4*delyub*delyt)
c
               cof8=hxa/(c4*delxua*delxt)+hya/(c4*delyua*delyt)
c
               cof0=-(cof1+cof2+cof3+cof4+cof5+cof6+cof7+cof8)
c
#ifdef freesurf
c
c--------------------------------------------------------------
c  Contribution to Matrix due to the presence of a free surface
c--------------------------------------------------------------
c
               cof0=cof0-diagcof
#endif
c
               a(i,j,0)=cof0*volmean
               a(i,j,1)=cof1*volmean
               a(i,j,2)=cof2*volmean
               a(i,j,3)=cof3*volmean
               a(i,j,4)=cof4*volmean
               a(i,j,5)=cof5*volmean
               a(i,j,6)=cof6*volmean
               a(i,j,7)=cof7*volmean
               a(i,j,8)=cof8*volmean
#ifdef lapfilter
               faceps=c0
               if( max(hxd,hxc).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,1)=a(i,j,1)+epsi
               endif
               if( max(hxa,hxb).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,2)=a(i,j,2)+epsi
               endif
               if( max(hxa,hxd).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,3)=a(i,j,3)+epsi
               endif
               if( max(hxb,hxc).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,4)=a(i,j,4)+epsi
               endif

               if( hxd.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,5)=a(i,j,5)-epsi*crossfac
               endif
               if( hxc.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,6)=a(i,j,6)-epsi*crossfac
               endif
               if( hxb.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,7)=a(i,j,7)-epsi*crossfac
               endif
               if( hxa.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,8)=a(i,j,8)-epsi*crossfac
               endif

               if(faceps.gt.0) then
                  a(i,j,0)=a(i,j,0)-faceps*epsi
               endif
#endif
c
#ifdef testinversion
          z0=xtest(i,j)
          z1=xtest(i,j+1)
          z2=xtest(i,j-1)
          z3=xtest(i-1,j)
          z4=xtest(i+1,j)
          z5=xtest(i-1,j+1)
          z6=xtest(i+1,j+1)
          z7=xtest(i+1,j-1)
          z8=xtest(i-1,j-1)
          ztd(i,j)=a(i,j,0)*z0+a(i,j,1)*z1+a(i,j,2)*z2+a(i,j,3)*z3+
     *  a(i,j,4)*z4+a(i,j,5)*z5+a(i,j,6)*z6+a(i,j,7)*z7+a(i,j,8)*z8
#else
               ztd(i,j)=volmean*ztd(i,j)
#endif
c
 100        continue
 110     continue
 120  continue
c
#ifdef testsolver
      do 140 j=1,jm
         do 130 i=1,im
            write(tst8out) ztd(i,j)/volmean
 130     continue
 140  continue
#endif
c
#ifndef solvercg
      nnz=0
      nnn=0
      krow=1
      ia(1)=1
      do 200 j=jstr,jend
# ifdef coast
         do 190 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 200
            iend=iep(j,l)
# endif
            do 180 i=istr,iend
c
               nnn=nnn+1
               pspar(nnn)=pwork(i,j)
c          
               irow=ir(i,j)
c
               zztd=ztd(i,j)
               do 170 k=0,8
# ifndef cyclic
                  jcol=ir(i+ik(k),j+jkk(k))
# else
                  if(i.eq.2.and.ik(k).eq.-1)then
                     jcol=ir(im-1,j+jkk(k))
                  elseif(i.eq.im-1.and.ik(k).eq.1)then
                     jcol=ir(2,j+jkk(k))
                  else
                     jcol=ir(i+ik(k),j+jkk(k))
                  endif
# endif
                  if(jcol.gt.0) then
                     if(a(i,j,k).ne.c0) then
                        nnz=nnz+1
                        if(irow.gt.krow)then
                           do 150 kk=krow+1,irow
                              ia(kk)=nnz
 150                       continue
                           krow=irow
                        endif
                        ja(nnz)=jcol
                        am(nnz)=a(i,j,k)
# ifdef testsolver
                        write(tst11out,160)
     *                       nnn,jcol,a(i,j,k),i,j,k
 160                    format(2(1x,i9),1x,1pe17.8,3(1x,i3))
# endif
                     endif
                  else
                     zztd=zztd-
     *                    a(i,j,k)*pwork(i+ik(k),j+jkk(k))
                  endif
 170           continue
               rp(nnn)=zztd
 180        continue
 190     continue
 200  continue
      ia(krow+1)=nnz+ia(1)
#endif
c
c=======================================================================
c  Begin section to do 9-point conjugate gradient ======================
c=======================================================================
c
#ifndef solvercg
      call spars_solve(nnn,nnz,ia,ja,am,rp,pspar)
#else
      iou=stdout
# ifdef coast
      call Ellip_sol(im,jm,lseg,pwork,a,ztd,iep,isp,
# else
      call Ellip_sol(im,jm,pwork,a,ztd,
# endif
     *     wk(1,1),wk(1,2),wk(1,3),wk(1,4),iou)
#endif
c
c=======================================================================
c  End of conjugate gradient iteration loop ============================
c=======================================================================
c
c  Put new values of the variables in to the correct array
c  -------------------------------------------------------
#ifndef solvercg
      nnn=0
c
      do 230 j=jstr,jend
# ifdef coast
       do 220 l=1,lseg
          istr=isp(j,l)
          if(istr.eq.0) go to 230
          iend=iep(j,l)
# endif
          do 210 i=istr,iend
c
             nnn=nnn+1
             pwork(i,j)=pspar(nnn)
c          
 210      continue
 220   continue
 230  continue
#endif
#ifdef cyclic
      do 250 j=jstr,jend
# ifdef coast
       do 240 l=1,lseg
          istr=isp(j,l)
          if(istr.eq.0) go to 250
          iend=iep(j,l)
          if(istr.eq.2)then
             pwork(im,j)=pwork(2,j)
          endif
          if(iend.eq.im-1)then
             pwork(1,j)=pwork(im-1,j)
          endif
 240   continue
# else
       pwork(im,j)=pwork(2,j)
       pwork(1,j)=pwork(im-1,j)
# endif
 250  continue
#endif
#ifdef testsolver
      do 260 j=1,jm
      do 260 i=1,im
         write(tst10out,'(1pe17.8)') pwork(i,j)
 260  continue
#endif
c
#ifdef testinversion
      sumxx=-1000.0
      do 280 j=1,jm
         do 270 i=1,im
            xdiff=abs(xtest(i,j)-pwork(i,j))
            write(77,'(1pe17.8)') xdiff
            sumxx=max(sumxx,xdiff)
 270     continue
 280  continue
      write (stdout,*) 'Error from inversion (infinity norm) = ',sumxx
#endif
c
#ifdef lapfilter
      do 310 j=jstr,jend
# ifdef coast
         do 300 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 310
            iend=iep(j,l)
# endif
            do 290 i=istr,iend
c
c Remove filter contributions
c
               hxa=hvex(i-1,j-1)/vmetx(i-1,j-1)
               hxb=hvex(i,j-1)/vmetx(i,j-1)
               hxc=hvex(i,j)/vmetx(i,j)
               hxd=hvex(i-1,j)/vmetx(i-1,j)

               faceps=c0
               if( max(hxd,hxc).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,1)=a(i,j,1)-epsi
               endif
               if( max(hxa,hxb).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,2)=a(i,j,2)-epsi
               endif
               if( max(hxa,hxd).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,3)=a(i,j,3)-epsi
               endif
               if( max(hxb,hxc).gt.c0) then
                  faceps=faceps+c1
                  a(i,j,4)=a(i,j,4)-epsi
               endif

               if( hxd.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,5)=a(i,j,5)+epsi*crossfac
               endif
               if( hxc.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,6)=a(i,j,6)+epsi*crossfac
               endif
               if( hxb.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,7)=a(i,j,7)+epsi*crossfac
               endif
               if( hxa.gt.c0) then
                  faceps=faceps-crossfac
                  a(i,j,8)=a(i,j,8)+epsi*crossfac
               endif
               if(faceps.gt.0) then
                  a(i,j,0)=a(i,j,0)+faceps*epsi
               endif
c
 290        continue
 300     continue
 310  continue
c
#elif defined localfilter
      do 320 j=1,jm
      do 320 i=1,im
         xtest(i,j)=c0
 320  continue
c
      do 350 j=jstr,jend
# ifdef coast
         do 340 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 350
            iend=iep(j,l)
# endif
            do 330 i=istr,iend
               z0=pwork(i,j)
               z1=pwork(i,j+1)
               z2=pwork(i,j-1)
               z3=pwork(i-1,j)
               z4=pwork(i+1,j)
               z5=pwork(i-1,j+1)
               z6=pwork(i+1,j+1)
               z7=pwork(i+1,j-1)
               z8=pwork(i-1,j-1)
               resv1=a1*(z0+z5+z6+z7+z8)+b1*(z1+z2+z3+z4)
               resv2=a2*(z0+z5+z6+z7+z8)+b2*(z1+z2+z3+z4)
               xtest(i,j)=xtest(i,j)-thetacof*(a1*resv1+a2*resv2)
               xtest(i,j+1)=xtest(i,j+1)-thetacof*(b1*resv1+b2*resv2)
               xtest(i,j-1)=xtest(i,j-1)-thetacof*(b1*resv1+b2*resv2)
               xtest(i-1,j)=xtest(i-1,j)-thetacof*(b1*resv1+b2*resv2)
               xtest(i+1,j)=xtest(i+1,j)-thetacof*(b1*resv1+b2*resv2)
               xtest(i-1,j+1)=xtest(i-1,j+1)
     $              -thetacof*(a1*resv1+a2*resv2)
               xtest(i+1,j+1)=xtest(i+1,j+1)
     $              -thetacof*(a1*resv1+a2*resv2)
               xtest(i+1,j-1)=xtest(i+1,j-1)
     $              -thetacof*(a1*resv1+a2*resv2)
               xtest(i-1,j-1)=xtest(i-1,j-1)
     $              -thetacof*(a1*resv1+a2*resv2)
 330        continue
 340     continue
 350  continue
c
      do 380 j=jstr,jend
# ifdef coast
         do 370 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 380
            iend=iep(j,l)
# endif
            do 360 i=istr,iend
               pwork(i,j)=pwork(i,j)+xtest(i,j)
 360        continue
 370     continue
 380  continue
#endif
#if defined checkinversion
      nnn=0
      resreal=c0
c
      do 410 j=jstr,jend
# ifdef coast
       do 400 l=1,lseg
        istr=isp(j,l)
        if(istr.eq.0) go to 410
        iend=iep(j,l)
# endif
        do 390 i=istr,iend
          nnn=nnn+1
          z0=pwork(i,j)
          z1=pwork(i,j+1)
          z2=pwork(i,j-1)
          z3=pwork(i-1,j)
          z4=pwork(i+1,j)
          z5=pwork(i-1,j+1)
          z6=pwork(i+1,j+1)
          z7=pwork(i+1,j-1)
          z8=pwork(i-1,j-1)
          resv=a(i,j,0)*z0+a(i,j,1)*z1+a(i,j,2)*z2+a(i,j,3)*z3+
     *         a(i,j,4)*z4+a(i,j,5)*z5+a(i,j,6)*z6+a(i,j,7)*z7+
     *         a(i,j,8)*z8-ztd(i,j)
          resreal=resreal+resv*resv
          resvv(i,j)=resv
 390   continue
 400  continue
 410  continue
c
      do 420 j=1,jm
      do 420 i=1,im
         write(87,*) resvv(i,j)
 420  continue
c
      resreal=sqrt(resreal/FLoaT(nnn))
      write (stdout,*) 'Actual residual after filtering (2-norm) = ',
     &                 resreal
#endif
c
      return
      end
