#ifdef coast
       subroutine Stream_solve(im,jm,lseg,dx,dy,
     *                     isq,ieq,isz,iez,a,pwork,hvex,ztd,
#else
       subroutine Stream_solve(im,jm,dx,dy,
     *                     a,pwork,hvex,ztd,
#endif
     *                     vmetx,tmetxi,corfac,
     *                     ir,ia,ja,am,rp,pspar
#ifdef testinversion
     *                     ,xtest
#endif
     *                     )
c
c=======================================================================
c                                                                    ===
c        This subroutine assembles the matrix for the elliptic       ===
c        equation describing the surface pressure and calls          ===
c        SPARSKIT cg with ILU preconditioner solver.                 ===
c=======================================================================
c
c----------------------------------------------------------------------
c  Define global data.
c----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
#if defined testsolver 
# include <iounits.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iend,im,irow,istr,j,jcol,jend,jm,jstr,k,kk,krow,nnn,nnz,
     &        numcell
      integer ia(im*jm+1),ik(0:4),ir(im,jm),ja(9*im*jm),jkk(0:4)
#ifdef coast
      integer l,lseg
      integer ieq(jm,lseg),iez(jm,lseg),isq(jm,lseg),isz(jm,lseg)
#endif
      FLOAT
     &      avg_qty,avg_vol,cof0,cof1,cof2,cof3,cof4,delxt,delxua,
     &      delxud,delyt,delyub,delyuc,dx,dxt,dxuex,dy,dyt,dyuex,hxa,
     &      hxd,hyb,hyc,sumvol,volmean
#ifdef testinversion
     &      ,sumxx,xdiff,z0,z1,z2,z3,z4
#endif
      FLOAT
     &      a(im,jm,0:4),am(9*im*jm),corfac(im,jm),hvex(im,jm),
     &      pspar(im*jm),pwork(im,jm),rp(im*jm),tmetxi(im,jm),
     &      vmetx(im,jm),ztd(im,jm)
#ifdef testinversion
     &      ,xtest(im,jm)
#endif
c
c======================================================================
c  Begin executable code.
c======================================================================
c
c-----------------------------------------------------------------------
c  Initialize the work area
c-----------------------------------------------------------------------
c
      do 1112 i=1,im
      do 1112 j=1,jm
         ir(i,j)=0
      do 1112 k=0,4
         a(i,j,k)=c0
1112  continue
c
c  
c
      ik(0)=0
      ik(1)=0
      ik(2)=0
      ik(3)=-1
      ik(4)=1
c
      jkk(0)=0
      jkk(1)=1
      jkk(2)=-1
      jkk(3)=0
      jkk(4)=0
c

        dxt=dx
        dyt=dy
      dxuex=dx
      dyuex=dy
c
c     Estimate a mean area of grid cells to normalize point equations
c     ---------------------------------------------------------------
      sumvol=c0
      numcell=0
      istr=1
      iend=im-1
c
      do 1128 j=1,jm-1
#ifdef coast
       do 1128 l=1,lseg
         istr=isq(j,l)
         if(istr.eq.0) go to 1128
         iend=ieq(j,l)
#endif
        do 11291 i=istr,iend
          numcell=numcell+1
          avg_qty=hvex(i,j)/vmetx(i,j)+hvex(i,j)*vmetx(i,j)
          avg_vol=p5*dxuex*dyuex*avg_qty
          sumvol=sumvol+avg_vol
11291   continue
1128  continue
      volmean=sumvol/float(numcell)
c
c-----------------------------------------------------------------------
c  Get the RHS (divergence form) for the equation.
c-----------------------------------------------------------------------
c
#ifdef testinversion
      print *,'ZTD read as an input.'
c-----------------------------------------------------------------------
c  Check whether driver is working properly.
c-----------------------------------------------------------------------
      open(unit=tst9out,file='pbar_out_exact.dat',status='new')
      do 1401 j=1,jm
        do 1402 i=1,im
          xtest(i,j)=sin(pi*float(i)/float(im))
     *              *sin(pi*float(j)/float(jm))
          write(tst9out,'(1pe17.8)') xtest(i,j)
1402    continue
1401  continue
      close(tst9out)
#endif
c
c-----------------------------------------------------------------------
c  Generate arrays of coefficients for relaxation.
c-----------------------------------------------------------------------
c
      nnn=0
      istr=2
      iend=im-1
      jstr=2
      jend=jm-1
c
      do 11 j=jstr,jend
#ifdef coast
       do 11 l=1,lseg
        istr=isz(j,l)
        if(istr.eq.0) go to 11
        iend=iez(j,l)
#endif
        do 1129 i=istr,iend
          nnn=nnn+1
          ir(i,j)=nnn
          hxa=tmetxi(i-1,j)/hvex(i-1,j-1)+tmetxi(i,j)/hvex(i-1,j)
          hxd=tmetxi(i,j)/hvex(i,j-1)+tmetxi(i,j)/hvex(i,j)
c
          hyb=vmetx(i-1,j-1)/hvex(i-1,j-1)+vmetx(i,j-1)/hvex(i,j-1)
          hyc=vmetx(i-1,j)/hvex(i-1,j)+vmetx(i,j)/hvex(i,j)
c     
          delxua=dxuex
          delxud=dxuex
c
          delyub=dyuex
          delyuc=dyuex
c
          delxt=dxt
          delyt=dyt
c
          cof1= +(hyc/delyuc)/(c2*delyt)*tmetxi(i,j)
c
          cof2= +(hyb/delyub)/(c2*delyt)*tmetxi(i,j)
c
          cof3= +(hxa/delxua)/(c2*delxt)*tmetxi(i,j)
c
          cof4= +(hxd/delxud)/(c2*delxt)*tmetxi(i,j)
c
          cof1= cof1 + p5*(corfac(i  ,j  )-corfac(i-1,j  ))
     $         /(delxt*delyt)*tmetxi(i,j)
          cof2= cof2 - p5*(corfac(i  ,j-1)-corfac(i-1,j-1))
     $         /(delxt*delyt)*tmetxi(i,j)
          cof3= cof3 + p5*(corfac(i-1,j  )-corfac(i-1,j-1))
     $         /(delxt*delyt)*tmetxi(i,j)
          cof4= cof4 - p5*(corfac(i  ,j  )-corfac(i  ,j-1))
     $         /(delxt*delyt)*tmetxi(i,j)
          cof0=-(cof1+cof2+cof3+cof4)
c
c
          a(i,j,0)=cof0*volmean
          a(i,j,1)=cof1*volmean
          a(i,j,2)=cof2*volmean
          a(i,j,3)=cof3*volmean
          a(i,j,4)=cof4*volmean
c
c
#ifdef testinversion
          z0=xtest(i,j)
          z1=xtest(i,j+1)
          z2=xtest(i,j-1)
          z3=xtest(i-1,j)
          z4=xtest(i+1,j)
          ztd(i,j)=a(i,j,0)*z0+a(i,j,1)*z1+a(i,j,2)*z2+a(i,j,3)*z3+
     *  a(i,j,4)*z4
#else
          ztd(i,j)=volmean*ztd(i,j)
#endif
c
1129    continue
11     continue
c
#ifdef testsolver
       do 23451 j=1,jm
         do 23452 i=1,im
           write(tst8out) ztd(i,j)/volmean
23452    continue
23451  continue
#endif
c
      nnz=0
      nnn=0
      krow=1
      ia(1)=1
      do 1133 j=jstr,jend
#ifdef coast
       do 1133 l=1,lseg
        istr=isz(j,l)
        if(istr.eq.0) go to 1133
        iend=iez(j,l)
#endif
        do 11297 i=istr,iend
c
          nnn=nnn+1
          pspar(nnn)=pwork(i,j)
c          
          irow=ir(i,j)
c
          do 11397 k=0,4
# ifndef cyclic
            jcol=ir(i+ik(k),j+jkk(k))
# else
            if(i.eq.2.and.ik(k).eq.-1)then
               jcol=ir(im-1,j+jkk(k))
            elseif(i.eq.im-1.and.ik(k).eq.1)then
               jcol=ir(2,j+jkk(k))
            else
               jcol=ir(i+ik(k),j+jkk(k))
            endif
# endif

            if(jcol.gt.0) then
              if(a(i,j,k).ne.c0) then
                 nnz=nnz+1
                 if(irow.gt.krow)then
                    do 11396 kk=krow+1,irow
                       ia(kk)=nnz
11396               continue
                    krow=irow
                 endif
                 ja(nnz)=jcol
                 am(nnz)=a(i,j,k)
#ifdef testsolver
                 write(tst11out,1000)nnn,jcol,a(i,j,k),i,j,k
 1000            format(2(1x,i9),1x,e17.8,3(1x,i3))
#endif
              endif
            else
              ztd(i,j)=ztd(i,j)-a(i,j,k)*pwork(i+ik(k),j+jkk(k))
            endif
11397     continue
          rp(nnn)=ztd(i,j)
11297   continue
1133  continue
      ia(krow+1)=nnz+ia(1)
c
c=======================================================================
c  Begin section to do 5-point conjugate gradient ======================
c=======================================================================
c
      call spars_solve(nnn,nnz,ia,ja,am,rp,pspar)
c
c=======================================================================
c  End of conjugate gradient iteration loop ============================
c=======================================================================
c
c  Put new values of the variables in to the correct array
c  -------------------------------------------------------

      nnn=0
c
      do 1137 j=jstr,jend
#ifdef coast
       do 1137 l=1,lseg
        istr=isz(j,l)
        if(istr.eq.0) go to 1137
        iend=iez(j,l)
#endif
        do 11377 i=istr,iend
c
          nnn=nnn+1
          pwork(i,j)=pspar(nnn)
c          
11377   continue
1137  continue
c
#ifdef cyclic
      do 250 j=jstr,jend
# ifdef coast
       do 240 l=1,lseg
          istr=isz(j,l)
          if(istr.eq.0) go to 250
          iend=iez(j,l)
          if(istr.eq.2)then
             pwork(im,j)=pwork(2,j)
          endif
          if(iend.eq.im-1)then
             pwork(1,j)=pwork(im-1,j)
          endif
 240   continue
# else
       pwork(im,j)=pwork(2,j)
       pwork(1,j)=pwork(im-1,j)
# endif
 250  continue
#endif
c
#ifdef testsolver
      do 2137 j=1,jm
        do 2137 i=1,im
          write(tst10out,*) pwork(i,j)
2137  continue
#endif
c
#ifdef testinversion
      sumxx=-1000.0
      do 1147 j=1,jm
        do 1149 i=1,im
          xdiff=abs(xtest(i,j)-pwork(i,j))
          write(77,'(e17.8)') xdiff
          sumxx=max(sumxx,xdiff)
1149    continue
1147  continue
      write(stdout,'(e17.8)') sumxx
#endif
c
      return
      end
