c
c=======================================================================
c  Include file "ioi.h"
c=======================================================================
c
#ifndef rmdocinc
c  COR        correlation between observation and forecast errors.
c  ERRFLD     uniform expected forecast error for all fields.
#ifndef surfpress
c  ERRP       uniform observation error field for streamfunction.
#else
c  ERRP       uniform observation error field for surface pressure.
#endif
c  ERRTS      uniform observation error field for tracers.
c  ERRUV      uniform observation error field for velocity.
# ifdef surfpress
c  ERRUVB     uniform observation error field for barotropic velocity.
#endif
c  IAP        switch for transport streamfunction assimilation.
c  IAREAD     switch to read in a new set of assimilation fields.
c  IATS       switch for tracers assimilation.
c  IAUV       switch for internal velocity assimilation.
# ifdef surfpress
c  IAUVB      switch for external velocity assimilation.
# endif
c  MXOI       maximum number of assimilation cycles allowed.
c  OBSWGT     observation weigth per variable per cycle.
c  OERRMAX    maximum observation error value (per variable) found.
c  OERRMIN    minimum observation error value (per variable) found.
# ifndef surfpress
c  PFCTERR    expected forecast error for streamfunction.
c  POBS       observation streamfunction.
c  POBSERR    3-d observation error field for streamfunction.
#else
c  PFCTERR    expected forecast error for surface pressure.
c  POBS       observation surface pressure.
c  POBSERR    3-d observation error field for surface pressure.
#endif
c  TFCTERR    expected forecast error for tracers.
c  TOBS       observation tracers.
c  TOBSERR    3-d observation error field for tracers.
c  TOISEC     assimilation times from initial TTSEC.
c  TSAT       "saturation" time.  Decay rate for forecast reliability.  (s)
c             (for use with CPP option "fcsterr")
c  TTOI       current observation time.
# ifdef surfpress
c  UBFCTERR   expected forecast error for u-component barotropic velocity.
c  UBOB       observation barotropic u-component velocity.
c  UBOBERR    2-d observation error field for barotropic u-component velocity.
# endif
c  UFCTERR    expected forecast error for u-component velocity.
c  UOBS       observation u-component velocity.
c  UOBSERR    3-d observation error field for u-component velocity.
# ifdef surfpress
c  VBFCTERR   expected forecast error for v-component barotropic velocity.
c  VBOB       observation barotropic v-component velocity.
c  VBOBERR    2-d observation error field for barotropic v-component velocity.
# endif
c  VFCTERR    expected forecast error for v-component velocity.
c  VOBS       observation v-component velocity.
c  VOBSERR    3-d error field for v-component velocity.
c
c=======================================================================
c
#endif
      integer mxoi
      parameter (mxoi=500)
      integer trcshft
#ifndef surfpress
      parameter ( trcshft=3 )
#else
      parameter ( trcshft=5 )
#endif
c
      common /ioiparm/ iats,iauv,iap,iaread
#ifdef surfpress
     *                 ,iauvb
#endif
      integer iats(mxoi,nt),iauv(mxoi),iap(mxoi),iaread(mxoi)
#ifdef surfpress
     *                 ,iauvb(mxoi)
#endif
c
      common /foiparm/ toisec,cor,tsat
      FLOAT 
     *      toisec(mxoi),cor,tsat
c
      common /obsfld/ ttoi,tobs,uobs,vobs,pobs
#ifdef surfpress
     *      ,ubob,vbob
#endif
      FLOAT
     *      tobs(imt,km,nt),ttoi,uobs(imt,km),vobs(imt,km),pobs(imt)
#ifdef surfpress
     *      ,ubob(imt),vbob(imt)
#endif
c
      common /obserr/ obswgt,oerrmin,oerrmax,errts,erruv,errp,tobserr,
     *       uobserr,vobserr,pobserr
#ifdef surfpress
     *      ,erruvb,uboberr,vboberr
#endif
      FLOAT 
     *      obswgt(mxoi,nt+trcshft),oerrmin(nt+trcshft,km),
     *      oerrmax(nt+trcshft,km),
     *      errts(mxoi,km,nt),erruv(mxoi,km),errp(mxoi),
     *      tobserr(imt,km,nt),uobserr(imt,km),vobserr(imt,km),
     *      pobserr(imt)
#ifdef surfpress
     *      ,erruvb(mxoi),uboberr(imt),vboberr(imt)
#endif
c
       common /fcterr/ errfld,tfcterr,ufcterr,vfcterr,pfcterr
# ifdef surfpress
     *                ,ubfcterr,vbfcterr
# endif
       FLOAT 
#ifndef fcsterr
     *       errfld(mxoi,km,nt+3),tfcterr(imt,km,nt),
     *       ufcterr(imt,km),vfcterr(imt,km),pfcterr(imt)
# ifdef surfpress
     *       ,ubfcterr(imt),vbfcterr(imt)
# endif
#else
     *       errfld(mxoi,km,nt+3),tfcterr(imt,km,nt,jmt),
     *       ufcterr(imt,km,jmt),vfcterr(imt,km,jmt),pfcterr(imt,jmt)
# ifdef surfpress
     *       ,ubfcterr(imt,jmt),vbfcterr(imt,jmt)
# endif
#endif
