      subroutine set_oerr(dcur)
c
c=======================================================================
c                                                                    ===
c  This routine processes observation error fields to be used in     ===
c  the  OI  assimilation. Observations  errors are assumed to be     ===
c  normalized by their variance, so their values range from zero     ===
c  to one.                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <fdiag.h>
#include <hybrid.h>
#include <iounits.h>
#include <ndimen.h>
#include <obserr.h>
#include <pefldid.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,k,m,trcshft
      real c1,dcur,eval,c0
      parameter (c1=1.0,c0=0.0)
c
      data trcshft /3/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      write(stdout,10) dcur
  10  format(/,' Writing observation error fields for day = ',f12.4,/)
c
c-----------------------------------------------------------------------
c  Process observation errors.  Set error fields to EVAL when
c  the when such fields are nonexisting in the data file.  If
c  the velocity errors (internal and external components) are
c  not present derive them from the streamfunction field.
c-----------------------------------------------------------------------
c
      eval=c1
c
c  Observation errors for internal velocity.
c
      if((ioerr(1).eq.0.or.ioerr(2).eq.0).and.ioerr(0).eq.1) then
        do 40 k=1,kfld
          do 30 j=1,jm
            do 20 i=1,im
              ip=i+(j-1)*im
              psioerr(ip,k)=min(psioerr(ip,k),c1)
              psioerr(ip,k)=max(psioerr(ip,k),c0)
              uoerr(ip,k)=psioerr(ip,k)
  20        continue
  30      continue
  40    continue
        call interp(uoerr,depthmv,zfld,kfld,intopt)
        do 41 k=1,km
           do 31 j=1,jm
              do 21 i=1,im
                 ip=i+(j-1)*im
                 uoerr(ip,k)=min(c1,uoerr(ip,k))
                 uoerr(ip,k)=max(c0,uoerr(ip,k))
                 voerr(ip,k)=uoerr(ip,k)
 21           continue
 31        continue
 41     continue

      elseif((ioerr(1).eq.0.or.ioerr(2).eq.0).and.ioerr(0).eq.0) then
        do 70 k=1,km
          do 60 j=1,jm
            do 50 i=1,im
              ip=i+(j-1)*im
              uoerr(ip,k)=eval
              voerr(ip,k)=eval
  50        continue
  60      continue
  70    continue
      endif
c
c  Observation errors for transport streamfunction (external velocity)
c
      if((ioerr(4).eq.0).and.(ioerr(0).eq.1)) then
          do 90 j=1,jm
            do 80 i=1,im
              ip=i+(j-1)*im
              pbaroerr(ip)=min(psioerr(ip,1),c1)
              pbaroerr(ip)=max(psioerr(ip,1),c0)
  80        continue
  90      continue
      else
        do 120 j=1,jm
          do 110 i=1,im
            ip=i+(j-1)*im
            pbaroerr(ip)=eval
 110      continue
 120    continue
      endif
c
#ifdef surfpress
c  Observation errors for external velocity (surface pressure formulation only).
c
      if (ptype.gt.0) then
         do 121 ip = 1, (im*jm)
            ubaroerr(ip) = dzv(ip,1)*uoerr(ip,1)
 121     continue
         do 123 k = 2, km
            do 122 ip = 1, (im*jm)
               ubaroerr(ip) = ubaroerr(ip) + dzv(ip,k)*uoerr(ip,k)
 122        continue
 123     continue
         do 124 ip = 1, (im*jm)
            ubaroerr(ip) = ubaroerr(ip)/hvz(ip)
            ubaroerr(ip) = min(c1,ubaroerr(ip))
            ubaroerr(ip) = max(c0,ubaroerr(ip))
            vbaroerr(ip) = ubaroerr(ip)
 124     continue
      endif
c
#endif
c  Tracers.
c
      do 190 m=1,nt
        if(ioerr(m+4).eq.1) then
          do 150 k=1,kfld
            do 140 j=1,jm
              do 130 i=1,im
                ip=i+(j-1)*im
                toerr(ip,k,m)=min(toerr(ip,k,m),c1)
                toerr(ip,k,m)=max(toerr(ip,k,m),c0)
 130          continue
 140        continue
 150      continue
          call interp(toerr(1,1,m),depthmt,zfld,kfld,intopt)
          do 151 k=1,km
            do 141 j=1,jm
              do 131 i=1,im
                ip=i+(j-1)*im
                toerr(ip,k,m)=min(toerr(ip,k,m),c1)
                toerr(ip,k,m)=max(toerr(ip,k,m),c0)
 131         continue
 141      continue
 151   continue
        else
          do 180 k=1,km
            do 170 j=1,jm
              do 160 i=1,im
                ip=i+(j-1)*im
                toerr(ip,k,m)=eval
 160          continue
 170        continue
 180      continue
        endif
 190  continue
c
c----------------------------------------------------------------------
c  Get minimum and maximum values to be used in the assimilation.
c----------------------------------------------------------------------
c
c  Transport streamfunction/Surface pressure diagnostics.
c
#ifdef surfpress
      if (ptype.eq.0) then
#endif
         call fdiagn(pbaroerr,im,im,jm,pepoer,0,dcur)
#ifdef surfpress
       else
         call fdiagn(pbaroerr,im,im,jm,pesfor,0,dcur)
      endif
#endif
      do 200 k=1,km
        oerrmin(1,k)=min(fmin,c0)
        oerrmax(1,k)=max(fmax,c1)
 200  continue
c
c  Internal velocity field diagnostics.
c
      do 210 k=1,km
        call fdiagn(uoerr(1,k),im,im,jm,peuoer,k,dcur)
        oerrmin(2,k)=min(fmin,c0)
        oerrmax(2,k)=max(fmax,c1)
 210  continue
      do 220 k=1,km
        call fdiagn(voerr(1,k),im,im,jm,pevoer,k,dcur)
        oerrmin(3,k)=min(fmin,c0)
        oerrmax(3,k)=max(fmax,c1)
 220  continue
c
#ifdef surfpress
c  External velocity field diagnostics.
c
      if (ptype.gt.0) then
         call fdiagn(ubaroerr,im,im,jm,peubor,0,dcur)
         do 221 k=1,km
           oerrmin(4,k)=min(fmin,c0)
           oerrmax(4,k)=max(fmax,c1)
 221     continue
         call fdiagn(vbaroerr,im,im,jm,pevbor,0,dcur)
         do 222 k=1,km
           oerrmin(5,k)=min(fmin,c0)
           oerrmax(5,k)=max(fmax,c1)
 222     continue
         trcshft = 5
       else
         trcshft = 3
      endif
c
#endif
c  Tracer diagnostics.
c
      do 240 m=1,nt
        do 230 k=1,km
          call fdiagn(toerr(1,k,m),im,im,jm,toerid(m),k,dcur)
          oerrmin(m+trcshft,k)=min(fmin,c0)
          oerrmax(m+trcshft,k)=max(fmax,c1)
 230    continue
 240  continue
      return
      end
